/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.locator;

import com.canoo.webtest.engine.Context;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.interfaces.ITableLocator;
import com.canoo.webtest.steps.Step;
import com.canoo.webtest.steps.locator.TableNotFoundException;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import org.xml.sax.SAXException;

public class TableLocator
implements ITableLocator {
    private String fHtmlId;
    private String fDescription;
    private int fRow;
    private int fColumn;

    public void setHtmlId(String id) {
        this.fHtmlId = id;
    }

    public String getHtmlId() {
        return this.fHtmlId;
    }

    public void setId(String id) {
        this.setHtmlId(id);
    }

    public String getId() {
        return this.getHtmlId();
    }

    public void setRow(int row) {
        this.fRow = row;
    }

    public int getRow() {
        return this.fRow;
    }

    public void setColumn(int column) {
        this.fColumn = column;
    }

    public int getColumn() {
        return this.fColumn;
    }

    public void setDescription(String description) {
        this.fDescription = description;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String locateText(Context context, Step step) throws TableNotFoundException, IndexOutOfBoundsException, SAXException {
        try {
            HtmlElement htmlElement = this.getHtmlId() == null ? TableLocator.findFirstTable(context, step) : context.getCurrentHtmlResponse(step).getHtmlElementById(this.getHtmlId());
            if (!(htmlElement instanceof HtmlTable)) {
                throw new StepFailedException("Found '" + htmlElement.getTagName() + "' element when looking for 'table' element using htmlId " + this.getHtmlId(), step);
            }
            HtmlTable table = (HtmlTable)htmlElement;
            return table.getRow(this.getRow()).getCell(this.getColumn()).asText();
        }
        catch (ElementNotFoundException e) {
            throw new TableNotFoundException(this.getHtmlId());
        }
    }

    private static HtmlElement findFirstTable(Context context, Step step) {
        for (HtmlElement element : context.getCurrentHtmlResponse(step).getHtmlElementDescendants()) {
            if (!(element instanceof HtmlTable)) continue;
            return element;
        }
        throw new ElementNotFoundException("*", "*", "*");
    }
}

