/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.form;

import com.canoo.webtest.engine.StepExecutionException;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.form.AbstractSetFieldStep;
import com.canoo.webtest.util.FormUtil;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlFileInput;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import java.io.File;
import java.io.IOException;

public class SetFileField
extends AbstractSetFieldStep {
    private File fFileName;
    private boolean fCheckFileExists = true;

    public void setFileName(File filename) {
        this.fFileName = filename;
    }

    public File getFileName() {
        return this.fFileName;
    }

    public void setCheckFileExists(boolean b) {
        this.fCheckFileExists = b;
    }

    public boolean isCheckFileExists() {
        return this.fCheckFileExists;
    }

    protected HtmlForm findForm() {
        return FormUtil.findFormForField(this.getContext(), this.getFormName(), "input", "file", this.getName(), this);
    }

    protected boolean keepField(HtmlElement elt) {
        return "file".equals(elt.getAttribute("type"));
    }

    protected void setField(HtmlElement element) throws IOException {
        String attributeValue = element.getAttribute("type");
        if (!"file".equals(attributeValue)) {
            throw new StepFailedException("HTML input with id='" + this.getHtmlId() + "' is of type '" + attributeValue + "' but should be '" + "file" + "'", this);
        }
        HtmlFileInput fileInput = (HtmlFileInput)element;
        fileInput.setValueAttribute(this.getFileName().getAbsolutePath());
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullParamCheck(this.getFileName(), "fileName");
        if (this.isCheckFileExists() && !this.getFileName().exists()) {
            throw new StepExecutionException("File doesn't exist: " + this.getFileName().getAbsolutePath(), this);
        }
    }
}

