/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.control;

import com.canoo.webtest.engine.StepExecutionException;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.control.MultipleExecutionStepContainer;
import com.canoo.webtest.util.ConversionUtil;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class RetryStep
extends MultipleExecutionStepContainer {
    private static final Logger LOG = Logger.getLogger(RetryStep.class);
    private static final String DEFAULT_COUNTERNAME = "count";
    private String fMaxcount;
    private String fCounterName = "count";
    private int fCount;

    public String getCounterName() {
        return this.fCounterName;
    }

    public void setCounterName(String counterName) {
        this.fCounterName = counterName;
    }

    public void setMaxcount(String maxCount) {
        this.fMaxcount = maxCount;
    }

    public String getMaxcount() {
        return this.fMaxcount;
    }

    public void doExecute() throws Exception {
        boolean allOk = false;
        for (int i = 0; i < this.fCount && !allOk; ++i) {
            LOG.debug((Object)("count = " + i + "/" + (this.fCount - 1)));
            this.setWebtestProperty(this.getCounterName(), Integer.toString(i));
            Task iteration = this.createIterationWrapper("Retry " + i + "/" + (this.fCount - 1));
            try {
                iteration.perform();
                allOk = true;
                continue;
            }
            catch (BuildException accepted) {
                // empty catch block
            }
        }
        if (!allOk) {
            throw new StepFailedException("Failed - retried the nested steps " + this.fCount + " time(s) without success", this);
        }
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.fCount = ConversionUtil.convertToIntOrReject("Retry Count", this.getMaxcount(), this);
        if (this.fCount < 0) {
            throw new StepExecutionException("Retry count must be set and greater than or equal to 0!", this);
        }
    }
}

