/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.control;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.AbstractStepContainer;
import com.canoo.webtest.steps.control.GroupStep;
import com.canoo.webtest.util.ConversionUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;

public class IfStep
extends AbstractStepContainer {
    private static final Logger LOG = Logger.getLogger(IfStep.class);
    private String fTest;
    private String fUnless;
    private GroupStep fCondition;
    private GroupStep fThen;
    private GroupStep fElse;

    public void setTest(String test) {
        this.fTest = test;
    }

    public String getTest() {
        return this.fTest;
    }

    public void setUnless(String unless) {
        this.fUnless = unless;
    }

    public String getUnless() {
        return this.fUnless;
    }

    public void addCondition(GroupStep condition) {
        this.fCondition = condition;
    }

    public GroupStep getCondition() {
        return this.fCondition;
    }

    public void addThen(GroupStep then) {
        this.paramCheck(this.fThen != null, "Only one nested 'then' step is supported.");
        this.fThen = then;
    }

    public GroupStep getThen() {
        return this.fThen;
    }

    public void addElse(GroupStep elseStep) {
        this.paramCheck(this.fElse != null, "Only one nested 'else/otherwise' step is supported.");
        this.fElse = elseStep;
    }

    public GroupStep getElse() {
        return this.fElse;
    }

    public void addOtherwise(GroupStep otherwiseStep) {
        this.addElse(otherwiseStep);
    }

    public GroupStep getOtherwise() {
        return this.fElse;
    }

    public void doExecute() throws CloneNotSupportedException {
        boolean shouldRunSteps = this.runNestedTests();
        if (!shouldRunSteps) {
            if (this.getElse() != null) {
                this.executeContainedStep(this.getElse());
            }
            return;
        }
        if (this.getThen() != null) {
            this.executeContainedStep(this.getThen());
        } else if (this.getElse() == null) {
            this.executeContainedSteps();
        }
    }

    protected void verifyParameters() {
        super.verifyParameters();
        int testParamsNr = 0;
        if (StringUtils.isNotEmpty((String)this.getTest())) {
            ++testParamsNr;
        }
        if (StringUtils.isNotEmpty((String)this.getUnless())) {
            ++testParamsNr;
        }
        if (this.getCondition() != null) {
            ++testParamsNr;
        }
        this.paramCheck(testParamsNr == 0, "One of the 'test' or the 'unless' attributes or nested tags is required.");
        this.paramCheck(testParamsNr > 1, "Only one of the 'test' or the 'unless' attributes or nested tags allowed.");
        if (this.fThen != null || this.fElse != null) {
            this.paramCheck(this.getSteps().size() > 0, "When using 'then' and 'else/otherwise', nested steps most only be grouped inside the 'then' or 'else/otherwise' steps.");
        }
    }

    protected boolean runNestedTests() {
        if (StringUtils.isNotEmpty((String)this.getTest())) {
            return ConversionUtil.convertToBoolean(this.getTest(), false);
        }
        if (StringUtils.isNotEmpty((String)this.getUnless())) {
            return !ConversionUtil.convertToBoolean(this.getUnless(), false);
        }
        try {
            this.executeContainedStep(this.getCondition());
        }
        catch (BuildException e) {
            if (StepFailedException.isCausedByStepFailedException(e)) {
                LOG.debug((Object)"test failed");
                return false;
            }
            LOG.debug((Object)"BuildException not caused by a StepFailedException. Rethrowing.");
            throw e;
        }
        return true;
    }
}

