/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps;

import com.canoo.webtest.ant.WebtestTask;
import com.canoo.webtest.engine.Context;
import com.canoo.webtest.engine.EqualsStringVerfier;
import com.canoo.webtest.engine.IStringVerifier;
import com.canoo.webtest.engine.RegExStringVerifier;
import com.canoo.webtest.engine.StepExecutionException;
import com.canoo.webtest.interfaces.IComputeValue;
import com.canoo.webtest.reporting.IStepResultListener;
import com.canoo.webtest.steps.StepUtil;
import com.canoo.webtest.util.Checker;
import com.canoo.webtest.util.MapUtil;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Task;

public abstract class Step
extends Task
implements Serializable,
Cloneable {
    private static final Logger LOG = Logger.getLogger(Step.class);
    public static final String ELEMENT_ATTRIBUTE_NAME = "name";
    public static final String ELEMENT_ATTRIBUTE_ID = "id";
    public static final String DEFAULT_DESCRIPTION = "<unknown>";
    private Date fStarted;
    private Date fCompleted;
    private boolean fSuccessful;
    public static final String PROPERTY_TYPE_DEFAULT = null;
    public static final String PROPERTY_TYPE_DYNAMIC = "dynamic";
    public static final String PROPERTY_TYPE_ANT = "ant";
    public static final String PROPERTY_TYPE_ANT_STRICT = "antstrict";

    protected Step() {
    }

    private void checkSetup() {
        Checker.assertNonNull(this.getProject(), "Project cannot be null");
    }

    public Context getContext() {
        return WebtestTask.getThreadContext();
    }

    public abstract void doExecute() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        this.checkContextDefined();
        this.notifyStarted();
        try {
            ScriptException bgException;
            this.verifyParameters();
            this.doExecute();
            Context context = this.getContext();
            Page currentPage = context.getCurrentResponse();
            if (this.isPerformingAction() && currentPage != null && context.getConfig().isEasyAjax()) {
                int easyAjaxDelay = context.getConfig().getEasyAjaxDelay();
                LOG.debug((Object)("Easy AJAX waiting for task starting before " + easyAjaxDelay));
                long before = System.currentTimeMillis();
                context.getWebClient().waitForBackgroundJavaScriptStartingBefore((long)easyAjaxDelay);
                LOG.debug((Object)("Easy AJAX waited: " + (System.currentTimeMillis() - before) + "ms"));
            }
            if ((bgException = context.getBackgroundJSError()) != null) {
                this.handleException((Throwable)bgException);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        finally {
            this.notifyCompleted();
            this.notifyStepResultsListeners();
        }
        this.notifySuccess();
    }

    public boolean isPerformingAction() {
        return true;
    }

    private void checkContextDefined() {
        if (WebtestTask.getThreadContext() == null) {
            throw new StepExecutionException("Step not inside a webtest", this);
        }
    }

    protected void notifyStepResultsListeners() {
        Map results = this.getComputedParameters();
        if (results.isEmpty()) {
            LOG.debug((Object)"Step didn't produce results, no need to notifying listeners");
            return;
        }
        for (BuildListener listener : this.getProject().getBuildListeners()) {
            if (!(listener instanceof IStepResultListener)) continue;
            LOG.debug((Object)("Notifying " + listener + " of " + results.size() + " results"));
            ((IStepResultListener)listener).stepResults(results);
        }
    }

    protected void verifyParameters() {
    }

    public boolean hasDescription() {
        return StringUtils.isNotEmpty((String)this.getDescription());
    }

    public String getDescription(String prefix, String suffix) {
        String description = this.getDescription();
        if (!StringUtils.isNotEmpty((String)description)) {
            return "";
        }
        return prefix + description + suffix;
    }

    public long getDuration() {
        return this.fCompleted.getTime() - this.fStarted.getTime();
    }

    protected String getStepLabel() {
        return "Step[" + this.getStepLabelBrief() + "]";
    }

    private String getStepLabelBrief() {
        StringBuffer message = new StringBuffer();
        message.append(this.getTaskName());
        message.append(this.getDescription(" \"", "\""));
        message.append(" (").append(this.getContext().getCurrentStepNumber()).append("/");
        message.append(this.getContext().getNumberOfSteps()).append(")");
        return message.toString();
    }

    public boolean isCompleted() {
        return this.fStarted != null && this.fCompleted != null;
    }

    public boolean isStarted() {
        return this.fStarted != null;
    }

    public boolean isSuccessful() {
        return this.fSuccessful;
    }

    public void notifyCompleted() {
        this.fCompleted = new Date();
        LOG.debug((Object)("Completed Step: " + this.getStepLabelBrief()));
    }

    public void notifyStarted() {
        this.fStarted = new Date();
        LOG.info((Object)(">>>> Start Step: " + this.getStepLabelBrief()));
    }

    public void notifySuccess() {
        this.fSuccessful = true;
        LOG.debug((Object)("<<<< Successful Step: " + this.getStepLabelBrief()));
    }

    public void setStepid(String description) {
        LOG.warn((Object)"'stepid' is deprecated - use 'description' instead");
        this.setDescription(description);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(ClassUtils.getShortClassName(this.getClass()));
        sb.append(" at ");
        sb.append(this.getLocation().toString());
        sb.append(" with (");
        Map parms = this.getParameterDictionary();
        for (Object param : parms.keySet()) {
            sb.append(param).append("=\"").append(parms.get(param)).append("\"");
            sb.append(", ");
        }
        if (!parms.isEmpty()) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(")");
        return sb.toString();
    }

    protected String getDefaultPropertyType() {
        return this.getContext().getConfig().getDefaultPropertyType();
    }

    public void setWebtestProperty(String name, String value) {
        this.setWebtestProperty(name, value, null);
    }

    public void setWebtestProperty(String name, String value, String propertyType) {
        String thisPropType = propertyType == PROPERTY_TYPE_DEFAULT ? this.getDefaultPropertyType() : propertyType;
        LOG.debug((Object)("setWebtestProperty: " + name + "=" + value + " [" + thisPropType + "]"));
        if (StringUtils.isEmpty((String)thisPropType) || PROPERTY_TYPE_DYNAMIC.equals(thisPropType)) {
            this.getContext().getWebtest().setDynamicProperty(name, value);
            return;
        }
        if (PROPERTY_TYPE_ANT.equals(thisPropType)) {
            this.checkSetup();
            this.getProject().setProperty(name, value);
            return;
        }
        if (PROPERTY_TYPE_ANT_STRICT.equals(thisPropType)) {
            this.checkSetup();
            this.getProject().setNewProperty(name, value);
            return;
        }
        throw new StepExecutionException("Unknown propertyType: " + thisPropType, this);
    }

    public String getWebtestProperty(String name) {
        return this.getWebtestProperty(name, PROPERTY_TYPE_DEFAULT);
    }

    public String getWebtestProperty(String name, String propertyType) {
        String thisPropType = propertyType == PROPERTY_TYPE_DEFAULT ? this.getDefaultPropertyType() : propertyType;
        LOG.debug((Object)("getWebtestProperty(" + name + ") [" + thisPropType + "]"));
        if (StringUtils.isEmpty((String)thisPropType) || PROPERTY_TYPE_DYNAMIC.equals(thisPropType)) {
            return this.getContext().getWebtest().getDynamicProperty(name);
        }
        if (thisPropType.startsWith(PROPERTY_TYPE_ANT)) {
            this.checkSetup();
            return this.getProject().getProperty(name);
        }
        throw new StepExecutionException("Unknown propertyType: " + thisPropType, this);
    }

    public Map getWebtestProperties() {
        return this.getWebtestProperties(null);
    }

    public Map getWebtestProperties(String propertyType) {
        String thisPropType;
        String string = thisPropType = propertyType == null ? this.getDefaultPropertyType() : propertyType;
        if (StringUtils.isEmpty((String)thisPropType) || PROPERTY_TYPE_DYNAMIC.equals(thisPropType)) {
            return this.getContext().getWebtest().getDynamicProperties();
        }
        if (thisPropType.startsWith(PROPERTY_TYPE_ANT)) {
            this.checkSetup();
            return this.getProject().getProperties();
        }
        throw new StepExecutionException("Unknown propertyType: " + thisPropType, this);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected static IStringVerifier getVerifier(boolean useRegex) {
        return useRegex ? RegExStringVerifier.INSTANCE : EqualsStringVerfier.INSTANCE;
    }

    protected void handleException(Throwable t) {
        LOG.debug((Object)("Handling exception " + t.getClass().getName() + ": " + t.getMessage()), t);
        StepUtil.handleException(t);
    }

    protected void paramCheck(boolean condition, String message) {
        if (condition) {
            throw new StepExecutionException(message, this);
        }
    }

    protected void nullParamCheck(Object param, String paramName) {
        this.paramCheck(param == null, "Required parameter \"" + paramName + "\" not set!");
    }

    protected void emptyParamCheck(String param, String paramName) {
        this.paramCheck(StringUtils.isEmpty((String)param), "Required parameter \"" + paramName + "\" not set or set to empty string!");
    }

    protected void positiveOrZeroParamCheck(int value, String paramName) {
        if (value < 0) {
            throw new StepExecutionException(paramName + " parameter with value '" + value + "' must not be negative", this);
        }
    }

    protected void integerParamCheck(String param, String paramName, boolean nonNegative) {
        try {
            int value = Integer.parseInt(param);
            if (nonNegative && value < 0) {
                throw new StepExecutionException(paramName + " parameter with value '" + param + "' must not be negative", this);
            }
        }
        catch (NumberFormatException e) {
            throw new StepExecutionException("Can't parse " + paramName + " parameter with value '" + param + "' as an integer.", this);
        }
    }

    protected void optionalIntegerParamCheck(String param, String paramName, boolean nonNegative) {
        if (!StringUtils.isEmpty((String)param)) {
            this.integerParamCheck(param, paramName, nonNegative);
        }
    }

    protected void nullResponseCheck() {
        this.paramCheck(this.getContext() == null || this.getContext().getCurrentResponse() == null, "No current response available! Is previous invoke missing?");
    }

    public Map getParameterDictionary() {
        TreeMap parameterDictionary = new TreeMap();
        this.addComputedParameters(parameterDictionary);
        this.addInternalParameters(parameterDictionary);
        return parameterDictionary;
    }

    protected void addComputedParameters(Map map) {
        if (this instanceof IComputeValue) {
            String value = ((IComputeValue)((Object)this)).getComputedValue();
            MapUtil.putIfNotNull(map, "=> value", value);
        }
    }

    protected Map getComputedParameters() {
        HashMap map = new HashMap();
        this.addComputedParameters(map);
        return map;
    }

    private void addInternalParameters(Map map) {
        MapUtil.putIfNotNull(map, "taskName", this.getTaskName());
    }
}

