/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.pdftest;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.plugins.pdftest.AbstractVerifyPdfStep;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFField;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFPage;
import java.util.List;

public class PdfVerifyReadOnlyFieldStep
extends AbstractVerifyPdfStep {
    private String fName;
    private int fPage = -1;
    private boolean fReadOnly = true;

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public boolean getReadOnly() {
        return this.fReadOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.fReadOnly = readOnly;
    }

    public int getPage() {
        return this.fPage;
    }

    public void setPage(int page) {
        this.fPage = page;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullParamCheck(this.getName(), "name");
    }

    protected void verifyPdf(PDFPage pdfPage) {
        List fields = this.getPage() == -1 ? pdfPage.getFields(this.getName()) : pdfPage.getFields(this.getName(), this.getPage());
        if (fields.isEmpty()) {
            throw new StepFailedException("No field found", this);
        }
        for (PDFField field : fields) {
            if (field.isReadOnly() == this.getReadOnly()) continue;
            String msg = "Field with name >" + this.getName() + "< is " + (field.isReadOnly() ? "" : "not ") + "read-only!";
            throw new StepFailedException(msg, this);
        }
    }
}

