/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.pdftest;

import com.canoo.webtest.engine.EqualsStringVerfier;
import com.canoo.webtest.engine.IStringVerifier;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.plugins.pdftest.AbstractVerifyPdfStep;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFFont;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFPage;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PdfVerifyFontStep
extends AbstractVerifyPdfStep {
    private static final Logger LOG = Logger.getLogger(PdfVerifyFontStep.class);
    private boolean fMatchCase;
    private String fName;
    private String fType;
    private int fPage = -1;

    public void setName(String value) {
        this.fName = value;
    }

    public String getName() {
        return this.fName;
    }

    public void setType(String value) {
        this.fType = value;
    }

    public String getType() {
        return this.fType;
    }

    public void setPage(int value) {
        this.fPage = value;
    }

    public int getPage() {
        return this.fPage;
    }

    public void setMatchCase(boolean matchCase) {
        this.fMatchCase = matchCase;
    }

    public boolean getMatchCase() {
        return this.fMatchCase;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.paramCheck(this.getName() == null && this.getType() == null, "One of 'name' or 'type' is required!");
    }

    protected void verifyPdf(PDFPage pdfPage) {
        LOG.debug((Object)"Retrieving fonts");
        List fonts = pdfPage.getFonts();
        LOG.debug((Object)(fonts.size() + " fonts to examine"));
        IStringVerifier verifier = this.getVerifier();
        for (PDFFont font : fonts) {
            if (!this.verifyFont(font, verifier)) continue;
            LOG.info((Object)("Found font " + font));
            return;
        }
        LOG.info((Object)"No matching font found");
        StringBuffer sb = new StringBuffer("No font found with ");
        if (this.getName() != null) {
            sb.append("name >" + this.getName() + "< ");
        }
        if (this.getType() != null) {
            sb.append("type >" + this.getType() + "< ");
        }
        sb.append("(matchCase: " + this.getMatchCase() + ")");
        throw new StepFailedException(sb.toString(), this);
    }

    private boolean verifyFont(PDFFont font, IStringVerifier verifier) {
        LOG.debug((Object)("Testing font: " + font));
        try {
            if (this.getPage() != -1 && this.getPage() != font.getPage()) {
                LOG.debug((Object)("Page doesn't match: " + font.getPage()));
                return false;
            }
            boolean typeMatches = this.getType() == null || verifier.verifyStrings(this.getType(), font.getType());
            boolean nameMatches = this.getName() == null || verifier.verifyStrings(this.getName(), font.getName());
            LOG.debug((Object)("type match: " + typeMatches + ", name match: " + nameMatches));
            return typeMatches && nameMatches;
        }
        catch (RuntimeException e) {
            LOG.debug((Object)"Exception", (Throwable)e);
            throw e;
        }
    }

    private IStringVerifier getVerifier() {
        if (this.getMatchCase()) {
            return EqualsStringVerfier.INSTANCE;
        }
        return new IStringVerifier(){

            public boolean verifyStrings(String expectedValue, String actualValue) {
                return StringUtils.equalsIgnoreCase((String)expectedValue, (String)actualValue);
            }
        };
    }
}

