/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.pdftest;

import com.canoo.webtest.engine.ContextHelper;
import com.canoo.webtest.plugins.pdftest.AbstractPdfFilter;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFPage;
import org.apache.log4j.Logger;

public class PdfToTextFilter
extends AbstractPdfFilter {
    private static final Logger LOG = Logger.getLogger(PdfToTextFilter.class);
    private String fMode = "normal";
    private String fFragSep = " ";
    private String fLineSep = "\n";
    private String fPageSep;

    public String getPageSep() {
        return this.fPageSep;
    }

    public void setPageSep(String pageSep) {
        this.fPageSep = pageSep;
    }

    public String getLineSep() {
        return this.fLineSep;
    }

    public void setLineSep(String lineSep) {
        this.fLineSep = lineSep;
    }

    public String getFragSep() {
        return this.fFragSep;
    }

    public void setFragSep(String fragSep) {
        this.fFragSep = fragSep;
    }

    public String getMode() {
        return this.fMode;
    }

    public void setMode(String mode) {
        this.fMode = mode;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.paramCheck(!"normal".equals(this.getMode()) && !"groupByLines".equals(this.getMode()), "Invalid mode");
    }

    protected void doFilter(PDFPage pdfPage) {
        String defaultPageSep = ("normal".equals(this.getMode()) ? "\n" : "") + "[+++ NEW PAGE +++]\n";
        if (this.getPageSep() == null) {
            this.fPageSep = defaultPageSep;
        } else {
            this.fPageSep = this.fPageSep.replaceAll("\\\\n", "\n");
            this.fPageSep = this.fPageSep.replaceAll("\\\\r", "\r");
        }
        String text = pdfPage.getText(this.getFragSep(), this.getLineSep(), this.getPageSep(), this.getMode());
        LOG.debug((Object)("Filter result: >" + text + "<"));
        ContextHelper.defineAsCurrentResponse(this.getContext(), text, "text/plain", "http:" + this.getClass().getName());
    }
}

