/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.pdftest;

import com.canoo.webtest.engine.ContextHelper;
import com.canoo.webtest.plugins.pdftest.AbstractPdfFilter;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFBookmark;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFPage;

public class PdfToBookmarksFilter
extends AbstractPdfFilter {
    protected void doFilter(PDFPage pdfPage) {
        String bookmarks = this.extractBookmarkAsString(pdfPage);
        ContextHelper.defineAsCurrentResponse(this.getContext(), bookmarks, "text/plain", "http:" + this.getClass().getName());
    }

    private String extractBookmarkAsString(PDFPage pdfPage) {
        StringBuffer result = new StringBuffer();
        for (PDFBookmark bookmark : pdfPage.getBookmarks()) {
            if (bookmark.getParent() != null) continue;
            PdfToBookmarksFilter.extractBookmarkAsString(result, bookmark, "");
        }
        return result.toString();
    }

    private static void extractBookmarkAsString(StringBuffer result, PDFBookmark bookmark, String indentation) {
        result.append(indentation);
        result.append(bookmark.getTitle());
        result.append("\n");
        for (PDFBookmark child : bookmark.getchildren()) {
            PdfToBookmarksFilter.extractBookmarkAsString(result, child, indentation + "    ");
        }
    }
}

