/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.emailtest;

import com.canoo.webtest.engine.ContextHelper;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.plugins.emailtest.AbstractEmailFilter;
import com.canoo.webtest.util.ConversionUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import sun.misc.UUDecoder;

public class EmailMessageContentFilter
extends AbstractEmailFilter {
    private static final Logger LOG = Logger.getLogger(EmailMessageContentFilter.class);
    private String fContentType;
    private String fPartIndex;
    private String fFilename;

    public String getContentType() {
        return this.fContentType;
    }

    public void setContentType(String contentType) {
        this.fContentType = contentType;
    }

    public String getPartIndex() {
        return this.fPartIndex;
    }

    public void setPartIndex(String partIndex) {
        this.fPartIndex = partIndex;
    }

    protected void filterContent(Message message) throws MessagingException {
        if (StringUtils.isEmpty((String)this.getPartIndex())) {
            try {
                this.defineAsCurrentResponse(IOUtils.toString((InputStream)message.getInputStream()), message.getContentType());
                return;
            }
            catch (IOException e) {
                throw new MessagingException("Error extracting message: " + e.getMessage());
            }
        }
        int partIndex = ConversionUtil.convertToInt(this.getPartIndex(), 0);
        try {
            Object content = message.getContent();
            if (content instanceof Multipart) {
                this.extractMultiPartMessage((Multipart)content, partIndex);
                return;
            }
            this.extractSimpleMessage((String)content, partIndex);
        }
        catch (IOException e) {
            LOG.error((Object)"Error processing email message: ", (Throwable)e);
            throw new MessagingException("Error processing email message: " + e.getMessage());
        }
    }

    private void extractMultiPartMessage(Multipart parts, int partIndex) throws MessagingException {
        try {
            if (partIndex >= parts.getCount()) {
                throw new StepFailedException("PartIndex too large.", this);
            }
            BodyPart part = parts.getBodyPart(partIndex);
            String contentType = part.getContentType();
            if (!StringUtils.isEmpty((String)this.getContentType()) && !contentType.equals(this.getContentType())) {
                throw new MessagingException("Actual contentType of '" + contentType + "' did not match expected contentType of '" + this.fContentType + "'");
            }
            String disp = part.getDisposition();
            String filename = part.getFileName();
            InputStream inputStream = part.getInputStream();
            this.fFilename = "attachment".equals(disp) ? filename : this.getClass().getName();
            ContextHelper.defineAsCurrentResponse(this.getContext(), IOUtils.toString((InputStream)inputStream), contentType, "http://" + this.fFilename);
        }
        catch (IOException e) {
            throw new MessagingException("Error extracting part: " + e.getMessage());
        }
    }

    private void extractSimpleMessage(String content, int partIndex) throws MessagingException {
        byte[] data;
        ByteArrayInputStream byteStream = new ByteArrayInputStream(this.getRawBytes(content, partIndex));
        try {
            UUDecoder uudc = new UUDecoder();
            data = uudc.decodeBuffer((InputStream)byteStream);
        }
        catch (IOException e) {
            throw new MessagingException("Error Uudecoding attachment: " + e.getMessage());
        }
        if (StringUtils.isEmpty((String)this.fContentType)) {
            throw new StepFailedException("Attribute 'contentType' must be supplied for simple messages.", this);
        }
        this.defineAsCurrentResponse(data, this.getContentType());
    }

    private byte[] getRawBytes(String content, int partIndex) throws MessagingException {
        String lineStr = "(^.*$)";
        String startUuencodeStr = "begin \\d\\d\\d .*";
        String endUuencodeStr = "^end.*";
        Pattern linePattern = Pattern.compile("(^.*$)", 8);
        Matcher matcher = linePattern.matcher(content);
        boolean extracting = false;
        int count = 0;
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            String line = matcher.group(0);
            if (extracting) {
                if (line.matches("^end.*")) {
                    buf.append(" \n").append(line).append('\n');
                    extracting = false;
                    break;
                }
                buf.append(line).append('\n');
                continue;
            }
            if (!line.matches("begin \\d\\d\\d .*") || count++ != partIndex) continue;
            extracting = true;
            buf.append(line).append('\n');
            int lastSpace = line.lastIndexOf(" ");
            this.fFilename = line.substring(lastSpace + 1);
        }
        if (buf.length() == 0) {
            throw new StepFailedException("Unable to find part with index " + partIndex + ".");
        }
        LOG.debug((Object)("buf=" + buf.toString()));
        return buf.toString().getBytes();
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.optionalIntegerParamCheck(this.getPartIndex(), "partIndex", true);
    }
}

