/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension.spider;

import com.canoo.webtest.engine.Context;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.extension.spider.IReporter;
import com.canoo.webtest.extension.spider.IValidator;
import com.canoo.webtest.extension.spider.IVisitorStrategy;
import com.canoo.webtest.steps.StepUtil;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class Spider {
    private static final Logger LOG = Logger.getLogger(Spider.class);
    public static final IVisitorStrategy ALWAYS_ACCEPT_VISITOR_STRATEGY = new AlwaysAcceptVisitorStrategy();
    public static final IReporter NO_OP_REPORTER = new NoOpReporter();
    public static final IValidator NO_OP_VALIDATOR = new NoOpValidator();
    private final Map fVisitedLinks = new HashMap();
    private IReporter fReporter;
    private IVisitorStrategy fVisitorStrategy;
    private IValidator fValidator;
    private String fFileName;
    private int fDepth;
    private boolean fFailOnError;
    private Context fContext;

    public void setFailOnError(boolean failOnError) {
        this.fFailOnError = failOnError;
    }

    public void setFileName(String filename) {
        this.fFileName = filename;
    }

    public String getFileName() {
        return this.fFileName;
    }

    public void setDepth(int depth) {
        this.fDepth = depth;
    }

    public void setReporter(IReporter reporter) {
        this.fReporter = reporter;
    }

    public IReporter getReporter() {
        return this.fReporter;
    }

    public void setVisitorStrategy(IVisitorStrategy visitorStrategy) {
        this.fVisitorStrategy = visitorStrategy;
    }

    public IVisitorStrategy getVisitorStrategy() {
        return this.fVisitorStrategy;
    }

    public void setValidator(IValidator validator) {
        this.fValidator = validator;
    }

    public IValidator getValidator() {
        return this.fValidator;
    }

    Writer getWriter() throws IOException {
        OutputStreamWriter writer;
        if (this.fFileName != null) {
            File file = new File(this.fContext.getConfig().getWebTestResultDir(), this.fFileName);
            LOG.info((Object)("Writing in " + file));
            writer = new FileWriter(file);
        } else {
            LOG.info((Object)"Writing in standard output");
            writer = new OutputStreamWriter(System.out);
        }
        return writer;
    }

    void setContext(Context context) {
        this.fContext = context;
    }

    public void execute(Context context) {
        this.validate();
        this.fVisitedLinks.clear();
        this.setContext(context);
        this.doExecute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doExecute() {
        Writer writer = null;
        boolean success = false;
        try {
            writer = this.getWriter();
            this.fReporter.setWriter(writer);
            this.fReporter.writeHeader();
            this.visit((HtmlPage)this.fContext.getCurrentResponse(), this.fDepth);
            this.fReporter.writeFooter();
            success = true;
        }
        catch (Throwable e) {
            LOG.error((Object)("Problems during write: " + e.getMessage()), e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        return success;
    }

    void validate() {
        if (this.fDepth < 0) {
            throw new IllegalArgumentException("depth must be >= 0");
        }
        if (this.fFileName == null) {
            LOG.info((Object)"No file name defined, will output to console");
        }
        if (this.fReporter == null) {
            LOG.info((Object)"No reporter defined, using noop reporter");
            this.fReporter = NO_OP_REPORTER;
        }
        if (this.fValidator == null) {
            LOG.info((Object)"No validator defined, using noop validator");
            this.fValidator = NO_OP_VALIDATOR;
        }
        if (this.fVisitorStrategy == null) {
            LOG.info((Object)"No visitor strategy set, using noop strategy");
            this.fVisitorStrategy = ALWAYS_ACCEPT_VISITOR_STRATEGY;
        }
    }

    void visit(HtmlPage currentResponse, int depth) throws IOException {
        LOG.debug((Object)("report depth " + depth));
        for (HtmlAnchor link : currentResponse.getAnchors()) {
            Properties linkInfo = this.fValidator.validate(this.fDepth - depth, currentResponse, link);
            this.fReporter.write(linkInfo);
            if (depth <= 0 || !this.needsReport(link)) continue;
            this.processLink(link, depth);
        }
    }

    void processLink(HtmlAnchor link, int depth) throws IOException {
        block4: {
            try {
                this.follow(link);
                Page page = this.fContext.getCurrentResponse();
                if (page instanceof HtmlPage) {
                    this.visit((HtmlPage)page, depth - 1);
                } else {
                    WebResponse response = page.getWebResponse();
                    LOG.info((Object)("Don't going deeper in response for " + response.getWebRequest().getUrl() + " as it isn't an html page (content type: " + response.getContentType() + ", page" + page + ")"));
                }
            }
            catch (StepFailedException e) {
                LOG.error((Object)e.getMessage(), (Throwable)((Object)e));
                if (!this.fFailOnError) break block4;
                throw e;
            }
        }
    }

    void follow(HtmlAnchor link) {
        LOG.debug((Object)("Clicking on link with href: " + link.getHrefAttribute()));
        try {
            link.click();
        }
        catch (Exception ex) {
            StepUtil.handleException(ex);
        }
    }

    boolean needsReport(HtmlAnchor link) {
        if (this.fVisitedLinks.containsKey(link.getHrefAttribute())) {
            LOG.info((Object)(link.getHrefAttribute() + " skipped: already visited"));
            return false;
        }
        if (!this.fVisitorStrategy.accept(link)) {
            LOG.info((Object)(link.getHrefAttribute() + " skipped: rejected by visitor"));
            return false;
        }
        this.fVisitedLinks.put(link.getHrefAttribute(), Boolean.TRUE);
        return true;
    }

    private static class NoOpValidator
    implements IValidator {
        private static final Properties EMPTY_PROPERTIES = new Properties();

        private NoOpValidator() {
        }

        public Properties validate(int depth, HtmlPage webResponse, HtmlAnchor link) {
            return EMPTY_PROPERTIES;
        }
    }

    private static class NoOpReporter
    implements IReporter {
        private NoOpReporter() {
        }

        public void writeHeader() {
        }

        public void write(Properties linkInfo) {
        }

        public void setWriter(Writer writer) {
        }

        public void writeFooter() {
        }
    }

    private static class AlwaysAcceptVisitorStrategy
    implements IVisitorStrategy {
        private AlwaysAcceptVisitorStrategy() {
        }

        public boolean accept(HtmlAnchor link) {
            return true;
        }
    }
}

