/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension.groovy;

import com.canoo.webtest.engine.StepExecutionException;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.extension.groovy.DummyPrinter;
import com.canoo.webtest.steps.Step;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.codehaus.groovy.control.CompilationFailedException;

class GroovyInvoker {
    private static final Logger LOG = Logger.getLogger(GroovyInvoker.class);
    private static final String KEY_GROOVY_BINDING = GroovyInvoker.class.getName() + "#binding";

    GroovyInvoker() {
    }

    public void doExecute(Step step, String script) {
        Binding variables = this.getBinding(step);
        variables.setVariable("step", (Object)step);
        DummyPrinter out = new DummyPrinter(step, Level.INFO);
        variables.setVariable("out", (Object)out);
        GroovyShell shell = new GroovyShell(this.getClass().getClassLoader(), variables);
        try {
            LOG.debug((Object)("Evaluating script: " + StringUtils.abbreviate((String)script, (int)20)));
            shell.evaluate(script);
        }
        catch (CompilationFailedException e) {
            LOG.error((Object)"CompilationFailedException", (Throwable)e);
            throw new StepExecutionException("Cannot compile groovy code: " + script, step, e);
        }
        catch (AssertionError e) {
            LOG.info((Object)"AssertionError", (Throwable)((Object)e));
            throw new StepFailedException("Assertion failed within groovy code: " + script, step);
        }
        catch (RuntimeException e) {
            LOG.error((Object)"RuntimeException", (Throwable)e);
            throw new StepExecutionException("Error invoking groovy: " + e.getMessage(), step, e);
        }
        finally {
            out.flush();
        }
    }

    Binding getBinding(Step step) {
        Binding binding = (Binding)step.getWebtestProperties().get(KEY_GROOVY_BINDING);
        if (binding == null) {
            LOG.info((Object)"No existing binding for this webtest, creating a new one");
            binding = new Binding();
            step.getWebtestProperties().put(KEY_GROOVY_BINDING, binding);
        } else {
            LOG.info((Object)"Reusing existing binding of this webtest.");
        }
        return binding;
    }
}

