/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension.dialogs;

import com.canoo.webtest.engine.Context;
import com.canoo.webtest.extension.dialogs.AbstractDialogStep;
import java.util.ArrayList;
import java.util.List;

public class DialogHelper {
    private static final String EXPECTED_DIALOGS_KEY = "ExpectedDialogs";

    static int getExpectedDialogsCount(Context context) {
        return DialogHelper.getExpectedDialogs(context).size();
    }

    static void clearExpectedDialogs(Context context) {
        DialogHelper.getExpectedDialogs(context).clear();
    }

    static void addExpectedDialog(Context context, AbstractDialogStep abstractDialogStep) {
        DialogHelper.getExpectedDialogs(context).add(abstractDialogStep);
    }

    static AbstractDialogStep getNextExpectedDialog(Context context) {
        List expectedDialogs = DialogHelper.getExpectedDialogs(context);
        if (expectedDialogs.isEmpty()) {
            return null;
        }
        AbstractDialogStep thisDialog = (AbstractDialogStep)expectedDialogs.get(0);
        expectedDialogs.remove(0);
        return thisDialog;
    }

    private static List getExpectedDialogs(Context context) {
        DialogHelper.initIfNeeded(context);
        return (List)context.get(EXPECTED_DIALOGS_KEY);
    }

    private static void initIfNeeded(Context context) {
        if (!context.containsKey(EXPECTED_DIALOGS_KEY)) {
            context.put(EXPECTED_DIALOGS_KEY, new ArrayList());
        }
    }
}

