/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension;

import com.canoo.webtest.steps.AbstractFilter;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TagStripperFilter
extends AbstractFilter {
    private static void processHtml(Iterable iter, StringBuffer buf) {
        for (DomNode node : iter) {
            if (node instanceof DomText) {
                buf.append(((DomText)node).getData());
                continue;
            }
            TagStripperFilter.processHtml(node.getChildren(), buf);
        }
    }

    private static void processXml(NodeList childNodes, StringBuffer buf) {
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            if (n.hasChildNodes()) {
                TagStripperFilter.processXml(n.getChildNodes(), buf);
                continue;
            }
            buf.append(n.getNodeValue() == null ? "" : n.getNodeValue());
        }
    }

    public void doExecute() throws Exception {
        StringBuffer buf = new StringBuffer();
        Page currentResponse = this.getContext().getCurrentResponse();
        if (currentResponse instanceof HtmlPage) {
            HtmlPage page = (HtmlPage)currentResponse;
            TagStripperFilter.processHtml(page.getDocumentElement().getChildren(), buf);
        } else if (currentResponse instanceof XmlPage) {
            XmlPage page = (XmlPage)currentResponse;
            TagStripperFilter.processXml(page.getXmlDocument().getChildNodes(), buf);
        }
        this.defineAsCurrentResponse(buf.toString(), "text/plain");
    }
}

