/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MimeType {
    public static final MimeType ALL_MEDIA = new MimeType();
    private final List fMediaRanges = new ArrayList();

    private MimeType() {
        this.fMediaRanges.add(MediaRange.ALL_MEDIA_RANGES);
    }

    public MimeType(String mimeType) {
        String[] mts = mimeType.split("\\s*;\\s*");
        for (int i = 0; i < mts.length; ++i) {
            this.fMediaRanges.add(MediaRange.create(mts[i]));
        }
        if (this.fMediaRanges.size() > 1) {
            Collections.sort(this.fMediaRanges);
            if (this.fMediaRanges.get(0) instanceof AllMediaRanges) {
                this.fMediaRanges.clear();
                this.fMediaRanges.add(MediaRange.ALL_MEDIA_RANGES);
            } else {
                ArrayList original = new ArrayList(this.fMediaRanges);
                this.fMediaRanges.clear();
                Iterator it = original.iterator();
                MediaRange lastMR = (MediaRange)it.next();
                this.fMediaRanges.add(lastMR);
                while (it.hasNext()) {
                    MediaRange mediaRange = (MediaRange)it.next();
                    if (lastMR instanceof AllSubtypesMediaRanges && lastMR.getType().equals(mediaRange.getType())) continue;
                    this.fMediaRanges.add(mediaRange);
                    lastMR = mediaRange;
                }
            }
        }
    }

    public boolean match(String contentType) {
        Iterator it = this.fMediaRanges.iterator();
        while (it.hasNext()) {
            if (!((MediaRange)it.next()).match(contentType)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.fMediaRanges.iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append(";");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    static class AllSubtypesMediaRanges
    extends MediaRange {
        AllSubtypesMediaRanges(String mimetype) {
            super(mimetype);
        }

        public boolean match(String contentType) {
            return this.matchType(contentType);
        }

        public int compareTo(Object other) {
            if (other instanceof AllMediaRanges) {
                return 1;
            }
            if (!(other instanceof MediaRange)) {
                throw new ClassCastException("Can only compare to an other MediaRange");
            }
            int typeCmp = this.getType().compareTo(((MediaRange)other).getType());
            if (typeCmp != 0) {
                return typeCmp;
            }
            if (other instanceof AllSubtypesMediaRanges) {
                return 0;
            }
            return -1;
        }
    }

    static class AllMediaRanges
    extends MediaRange {
        AllMediaRanges() {
            super("*/*");
        }

        public boolean match(String contentType) {
            return true;
        }

        public int compareTo(Object other) {
            if (other instanceof AllMediaRanges) {
                return 0;
            }
            if (!(other instanceof MediaRange)) {
                throw new ClassCastException("Can only compare to an other MediaRange");
            }
            return -1;
        }
    }

    protected static class MediaRange
    implements Comparable {
        private final String fType;
        private final String fSubtype;
        static final AllMediaRanges ALL_MEDIA_RANGES = new AllMediaRanges();

        public static MediaRange create(String mymetype) {
            if ("*/*".equals(mymetype)) {
                return ALL_MEDIA_RANGES;
            }
            if (mymetype.startsWith("*/")) {
                throw new IllegalArgumentException("'" + mymetype + "' is not a valid syntax.");
            }
            if (mymetype.endsWith("/*")) {
                return new AllSubtypesMediaRanges(mymetype);
            }
            return new MediaRange(mymetype);
        }

        protected MediaRange(String mymetype) {
            int idx = mymetype.indexOf("/");
            if (idx == -1) {
                throw new IllegalArgumentException("'" + mymetype + "' is not a valid syntax.");
            }
            this.fType = mymetype.substring(0, idx + 1);
            this.fSubtype = mymetype.substring(idx);
        }

        public boolean match(String contentType) {
            return this.matchType(contentType) && this.matchSubtype(contentType);
        }

        boolean matchSubtype(String contentType) {
            return contentType.endsWith(this.fSubtype);
        }

        boolean matchType(String contentType) {
            return contentType.startsWith(this.fType);
        }

        public String getType() {
            return this.fType;
        }

        public String getSubtype() {
            return this.fSubtype;
        }

        public String toString() {
            return this.fType + this.fSubtype.substring(1);
        }

        public int compareTo(Object other) {
            if (other instanceof AllMediaRanges) {
                return 1;
            }
            if (!(other instanceof MediaRange)) {
                throw new ClassCastException("Can only compare to an other MediaRange");
            }
            int typeCmp = this.getType().compareTo(((MediaRange)other).getType());
            if (typeCmp != 0) {
                return typeCmp;
            }
            if (other instanceof AllSubtypesMediaRanges) {
                return 1;
            }
            return this.getSubtype().compareTo(((MediaRange)other).getSubtype());
        }
    }
}

