/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.engine.xpath;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.engine.xpath.CleanTextFunction;
import com.canoo.webtest.engine.xpath.MatchesFunction;
import com.canoo.webtest.engine.xpath.PrefixResolver;
import com.canoo.webtest.engine.xpath.SimpleNamespaceContext;
import com.canoo.webtest.engine.xpath.SimpleXPathFunctionResolver;
import com.canoo.webtest.engine.xpath.SimpleXPathVariableResolver;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.xpath.XPathUtils;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.log4j.Logger;
import org.apache.xpath.Expression;
import org.apache.xpath.ExtensionsProvider;
import org.apache.xpath.VariableStack;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.functions.FuncExtFunction;
import org.apache.xpath.functions.Function;
import org.apache.xpath.functions.WrongNumberArgsException;
import org.apache.xpath.jaxp.JAXPVariableStack;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XObjectFactory;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathHelper {
    private static final Logger LOG = Logger.getLogger(XPathHelper.class);
    private SimpleXPathVariableResolver fVariableContext = new SimpleXPathVariableResolver();
    private SimpleXPathFunctionResolver fFunctionContext = new SimpleXPathFunctionResolver();
    private SimpleNamespaceContext fNamespaceContext = new SimpleNamespaceContext();
    final ThreadLocal<Boolean> htmlUnitXPathUtil_XPathProcessingFlag_;
    private static Map<QName, Object> sGlobalVariables = Collections.synchronizedMap(new HashMap());
    private static Map<QName, Class<? extends Function>> sGlobalFunctions = Collections.synchronizedMap(new HashMap());
    private static Map<String, String> sGlobalNamespaces = Collections.synchronizedMap(new HashMap());

    public static void registerGlobalVariable(String namespaceURI, String localName, Object value) {
        sGlobalVariables.put(new QName(namespaceURI, localName), value);
    }

    private static void registerWebTestGoodies() {
        String namespaceURI = "http://webtest.canoo.com";
        XPathHelper.registerGlobalNamespace("wt", "http://webtest.canoo.com");
        XPathHelper.registerGlobalFunction("http://webtest.canoo.com", "matches", MatchesFunction.class);
        XPathHelper.registerGlobalFunction("http://webtest.canoo.com", "cleanText", CleanTextFunction.class);
    }

    public static Map<QName, Object> getGlobalVariables() {
        return sGlobalVariables;
    }

    public static Map<QName, Class<? extends Function>> getGlobalFunctions() {
        return sGlobalFunctions;
    }

    public static Map<String, String> getGlobalNamespaces() {
        return sGlobalNamespaces;
    }

    public static void registerGlobalFunction(String namespaceURI, String localName, Class<? extends Function> function) {
        sGlobalFunctions.put(new QName(namespaceURI, localName), function);
    }

    public static void registerGlobalNamespace(String prefix, String namespaceURI) {
        sGlobalNamespaces.put(prefix, namespaceURI);
    }

    public XPathHelper() {
        QName memberKey;
        for (Map.Entry<String, String> entry : XPathHelper.getGlobalNamespaces().entrySet()) {
            this.getNamespaceContext().addNamespace(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : XPathHelper.getGlobalFunctions().entrySet()) {
            memberKey = (QName)entry.getKey();
            this.getFunctionContext().registerFunction(memberKey, (Class)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : XPathHelper.getGlobalVariables().entrySet()) {
            memberKey = (QName)entry.getKey();
            this.getVariableContext().setVariableValue(memberKey, entry.getValue());
        }
        try {
            Field f = XPathUtils.class.getDeclaredField("PROCESS_XPATH_");
            f.setAccessible(true);
            this.htmlUnitXPathUtil_XPathProcessingFlag_ = (ThreadLocal)f.get(XPathUtils.class);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to hack HtmlUnit-2.4 XPathUtils.PROCESS_XPATH_", exception);
        }
    }

    public SimpleXPathFunctionResolver getFunctionContext() {
        return this.fFunctionContext;
    }

    public SimpleNamespaceContext getNamespaceContext() {
        return this.fNamespaceContext;
    }

    public SimpleXPathVariableResolver getVariableContext() {
        return this.fVariableContext;
    }

    protected Object getDocument(Page page) {
        if (page == null) {
            return null;
        }
        if (page instanceof HtmlPage) {
            return page;
        }
        if (page instanceof XmlPage) {
            XmlPage xmlPage = (XmlPage)page;
            if (xmlPage.getXmlDocument() == null) {
                throw new StepFailedException("The xml document couldn't be parsed as it is not well formed");
            }
            return xmlPage.getXmlDocument();
        }
        throw this.buildInvalidDocumentException(page);
    }

    StepFailedException buildInvalidDocumentException(Page page) {
        return new StepFailedException("Current response is not an HTML or XML page but of type " + page.getWebResponse().getContentType() + " (" + page.getClass().getName() + ")");
    }

    public String stringValueOf(Page _page, String _xpath) throws XPathExpressionException {
        try {
            this.htmlUnitXPathUtil_XPathProcessingFlag_.set(true);
            XObject result = this.eval(_xpath, this.getDocument(_page));
            String string = result.str();
            return string;
        }
        catch (TransformerException e) {
            throw this.handleException(e);
        }
        finally {
            this.htmlUnitXPathUtil_XPathProcessingFlag_.set(false);
        }
    }

    private XPathExpressionException handleException(TransformerException _e) {
        Throwable nestedException = _e.getException();
        if (nestedException instanceof XPathFunctionException) {
            return (XPathFunctionException)nestedException;
        }
        LOG.info((Object)"XPath error", (Throwable)_e);
        return new XPathExpressionException(_e.getMessage());
    }

    public List<? extends Object> selectNodes(Page _page, String _xpath) throws XPathExpressionException {
        return (List)this.getByXPath(_page, _xpath, false);
    }

    public Object selectFirst(Page _page, String _xpath) throws XPathExpressionException {
        return this.getByXPath(_page, _xpath, true);
    }

    protected Object getByXPath(Page _currentResp, String _xpath, boolean _onlyFirstResult) throws XPathExpressionException {
        try {
            this.htmlUnitXPathUtil_XPathProcessingFlag_.set(true);
            XObject result = this.eval(_xpath, this.getDocument(_currentResp));
            switch (result.getType()) {
                case 1: {
                    Boolean bl = result.bool();
                    return bl;
                }
                case 2: {
                    Double d = result.num();
                    return d;
                }
                case 3: {
                    String string = result.str();
                    return string;
                }
                case 4: {
                    if (_onlyFirstResult) {
                        Node node = result.nodeset().nextNode();
                        return node;
                    }
                    List<Node> list = this.toList(result.nodeset());
                    return list;
                }
            }
            try {
                throw new RuntimeException("Unexpected result type for >" + _xpath + "<: " + result.getType());
            }
            catch (TransformerException e) {
                throw this.handleException(e);
            }
        }
        finally {
            this.htmlUnitXPathUtil_XPathProcessingFlag_.set(false);
        }
    }

    private List<Node> toList(NodeIterator _nodeset) {
        ArrayList<Node> result = new ArrayList<Node>();
        Node node = _nodeset.nextNode();
        while (node != null) {
            result.add(node);
            node = _nodeset.nextNode();
        }
        return result;
    }

    private XObject eval(String expression, Object contextItem) throws TransformerException {
        XPathContext xpathSupport;
        PrefixResolver prefixResolver = new PrefixResolver(this.fNamespaceContext, contextItem);
        XPath xpath = new XPath(expression, null, (org.apache.xml.utils.PrefixResolver)prefixResolver, 0, null, this.fFunctionContext.getFunctionTable());
        final XPathContext[] contexts = new XPathContext[]{null};
        ExtensionsProvider extProvider = new ExtensionsProvider(){

            public boolean elementAvailable(String _ns, String _elemName) throws TransformerException {
                return false;
            }

            public Object extFunction(FuncExtFunction _extFunction, Vector _argVec) throws TransformerException {
                String ns = _extFunction.getNamespace();
                String name = _extFunction.getFunctionName();
                Function func = XPathHelper.this.fFunctionContext.resolveFunction(new QName(ns, name), 0);
                if (func == null) {
                    throw new RuntimeException("Can't find function " + name + " (namespace: " + ns + ")");
                }
                for (int i = 0; i < _argVec.size(); ++i) {
                    try {
                        func.setArg((Expression)XObjectFactory.create(_argVec.get(i)), i);
                        continue;
                    }
                    catch (WrongNumberArgsException e) {
                        throw new RuntimeException(e);
                    }
                }
                return func.execute(contexts[0]);
            }

            public Object extFunction(String _ns, String _funcName, Vector _argVec, Object _methodKey) throws TransformerException {
                return null;
            }

            public boolean functionAvailable(String _ns, String _funcName) throws TransformerException {
                return XPathHelper.this.fFunctionContext.resolveFunction(new QName(_ns, _funcName), 0) != null;
            }
        };
        contexts[0] = xpathSupport = new XPathContext((Object)extProvider);
        xpathSupport.setVarStack((VariableStack)new JAXPVariableStack((XPathVariableResolver)this.fVariableContext));
        XObject xobj = contextItem instanceof Node ? xpath.execute(xpathSupport, (Node)contextItem, (org.apache.xml.utils.PrefixResolver)prefixResolver) : xpath.execute(xpathSupport, -1, (org.apache.xml.utils.PrefixResolver)prefixResolver);
        return xobj;
    }

    public static String quote(String value) {
        if (!value.contains("'")) {
            return "'" + value + "'";
        }
        if (!value.contains("\"")) {
            return "\"" + value + "\"";
        }
        String[] parts = value.split("'");
        String response = "concat(";
        for (int i = 0; i < parts.length - 1; ++i) {
            response = response + "'" + parts[i] + "', \"'\", ";
        }
        response = response + "'" + parts[parts.length - 1] + "')";
        return response;
    }

    static {
        XPathHelper.registerWebTestGoodies();
    }
}

