/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.engine.xpath;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.apache.xpath.jaxp.JAXPPrefixResolver;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class PrefixResolver
extends JAXPPrefixResolver {
    private final Map<String, String> grabbedNamespaces = new HashMap<String, String>();
    private String defaultNamespace = "WebTestDefaultNamespace";

    public PrefixResolver(NamespaceContext nsContext, Object _contextItem) {
        super(nsContext);
        if (_contextItem instanceof Document) {
            NamedNodeMap docEltAttributes = ((Document)_contextItem).getDocumentElement().getAttributes();
            for (int i = 0; i < docEltAttributes.getLength(); ++i) {
                Node attrNode = docEltAttributes.item(i);
                if (attrNode.getNodeName().startsWith("xmlns:")) {
                    String namespace = attrNode.getNodeName().substring(6);
                    this.grabbedNamespaces.put(namespace, attrNode.getNodeValue());
                    continue;
                }
                if (!attrNode.getNodeName().equals("xmlns")) continue;
                this.defaultNamespace = attrNode.getNodeValue();
            }
        }
    }

    public String getNamespaceForPrefix(String _prefix) {
        if (_prefix.length() == 0) {
            return this.defaultNamespace;
        }
        String ns = this.grabbedNamespaces.get(_prefix);
        if (ns != null) {
            return ns;
        }
        return super.getNamespaceForPrefix(_prefix);
    }
}

