/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.engine.xpath;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.apache.xpath.XPathContext;
import org.apache.xpath.functions.Function3Args;
import org.apache.xpath.functions.WrongNumberArgsException;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XObject;

public class MatchesFunction
extends Function3Args {
    private static final Logger LOG = Logger.getLogger(MatchesFunction.class);

    public XObject execute(XPathContext xctxt) throws TransformerException {
        String input = this.getArg0().execute(xctxt).xstr().toString();
        String regex = this.getArg1().execute(xctxt).xstr().toString();
        LOG.debug((Object)("input: " + input));
        String flags = this.getArg2() != null ? this.getArg2().execute(xctxt).xstr().toString() : null;
        return new XBoolean(this.doExecute(input, regex, flags));
    }

    boolean doExecute(String input, String regex, String flagsString) throws TransformerException {
        int flags = flagsString == null ? 0 : MatchesFunction.computeFlags(flagsString);
        Pattern pattern = Pattern.compile(regex, flags);
        Matcher matcher = pattern.matcher(input);
        return matcher.find();
    }

    static int computeFlags(String flags) throws TransformerException {
        char c;
        int flag = 0;
        block6: for (int i = 0; i < flags.length() && flags.indexOf(c = flags.charAt(i)) == i; ++i) {
            switch (c) {
                case 's': {
                    flag += 32;
                    continue block6;
                }
                case 'm': {
                    flag += 8;
                    continue block6;
                }
                case 'i': {
                    flag += 2;
                    continue block6;
                }
                case 'x': {
                    flag += 4;
                    continue block6;
                }
                default: {
                    throw new TransformerException("Illegal flag used for call to matches: " + c);
                }
            }
        }
        return flag;
    }

    public void checkNumberArgs(int _argNum) throws WrongNumberArgsException {
        if (_argNum < 2 || _argNum > 3) {
            throw new WrongNumberArgsException("function matches accept 2 or 3 arguments, not " + _argNum);
        }
    }
}

