/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.boundary;

import com.canoo.webtest.engine.StepExecutionException;
import com.canoo.webtest.steps.Step;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;

public final class UrlBoundary {
    private static final Logger LOG = Logger.getLogger(UrlBoundary.class);

    private UrlBoundary() {
    }

    public static URL tryCreateUrl(String urlStr) {
        try {
            return new URL(urlStr);
        }
        catch (MalformedURLException e) {
            LOG.error((Object)("Creating URL '" + urlStr + "' failed: " + e.getMessage()));
            throw new RuntimeException(e);
        }
    }

    public static URL tryCreateUrlWithError(URL resource, String urlStr, Step step) {
        try {
            return new URL(resource, urlStr);
        }
        catch (MalformedURLException e) {
            LOG.error((Object)("Creating URL '" + urlStr + "' failed: " + e.getMessage()));
            throw new StepExecutionException(e.getMessage(), step);
        }
    }

    public static URL tryCreateUrlFromFileWithError(File urlFile, Step step) {
        try {
            return urlFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            LOG.error((Object)("Creating URL for File '" + urlFile.getName() + "' failed: " + e.getMessage()));
            throw new StepExecutionException(e.getMessage(), step);
        }
    }
}

