/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.boundary;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.BuildException;

public class ResetScriptRunner {
    private String fLanguage;
    private String fScript;
    private Map fBeans = new HashMap();
    private BSFManager fManager;

    public ResetScriptRunner() {
        this.reset();
    }

    public void reset() {
        this.fScript = "";
    }

    public void addBeans(Map dictionary) {
        for (String key : dictionary.keySet()) {
            try {
                Object val = dictionary.get(key);
                this.addBean(key, val);
            }
            catch (BuildException ex) {}
        }
    }

    public void addBean(String key, Object bean) {
        boolean isValid = key.length() > 0 && Character.isJavaIdentifierStart(key.charAt(0));
        for (int i = 1; isValid && i < key.length(); ++i) {
            isValid = Character.isJavaIdentifierPart(key.charAt(i));
        }
        if (isValid) {
            this.fBeans.put(key, bean);
        }
    }

    public void executeScript(String execName) throws BuildException {
        if (this.fLanguage == null) {
            throw new BuildException("script language must be specified");
        }
        try {
            if (this.fManager == null) {
                this.fManager = this.prepareManager();
            }
            this.fManager.exec(this.fLanguage, execName, 0, 0, (Object)this.fScript);
        }
        catch (BSFException be) {
            throw ResetScriptRunner.createBuildException(be);
        }
    }

    public String evalScript(String execName) throws BuildException {
        if (this.fLanguage == null) {
            throw new BuildException("script language must be specified");
        }
        try {
            if (this.fManager == null) {
                this.fManager = this.prepareManager();
            }
            return this.fManager.eval(this.fLanguage, execName, 0, 0, (Object)this.fScript).toString();
        }
        catch (BSFException be) {
            throw ResetScriptRunner.createBuildException(be);
        }
    }

    private BSFManager prepareManager() throws BSFException {
        BSFManager manager = new BSFManager();
        for (String key : this.fBeans.keySet()) {
            Object value = this.fBeans.get(key);
            if (value != null) {
                manager.declareBean(key, value, value.getClass());
                continue;
            }
            manager.undeclareBean(key);
        }
        return manager;
    }

    private static BuildException createBuildException(BSFException be) {
        Throwable t = be;
        Throwable te = be.getTargetException();
        if (te != null) {
            if (te instanceof BuildException) {
                return (BuildException)te;
            }
            t = te;
        }
        return new BuildException(t);
    }

    public void setLanguage(String lang) {
        this.fLanguage = lang;
    }

    public String getLanguage() {
        return this.fLanguage;
    }

    public void setSrc(File file) {
        if (!file.exists()) {
            throw new BuildException("file " + file.getPath() + " not found.");
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            this.fScript = this.fScript + IOUtils.toString((InputStream)inputStream);
        }
        catch (IOException e) {
            try {
                throw new BuildException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    public void addText(String text) {
        this.fScript = this.fScript + text;
    }

    static {
        BSFManager.registerScriptingEngine((String)"groovy", (String)"org.codehaus.groovy.bsf.GroovyEngine", (String[])new String[]{"groovy", "gy"});
    }
}

