/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.resolver.filter.IncludesArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.webstart.AbstractBaseJnlpMojo;
import org.codehaus.mojo.webstart.JnlpConfig;
import org.codehaus.mojo.webstart.JnlpExtension;
import org.codehaus.mojo.webstart.generator.ExtensionGenerator;
import org.codehaus.mojo.webstart.generator.ExtensionGeneratorConfig;
import org.codehaus.mojo.webstart.generator.Generator;
import org.codehaus.mojo.webstart.generator.GeneratorConfig;
import org.codehaus.mojo.webstart.generator.GeneratorTechnicalConfig;
import org.codehaus.mojo.webstart.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJnlpMojo
extends AbstractBaseJnlpMojo {
    private static final String BUILT_IN_JNLP_TEMPLATE_FILENAME = "default-jnlp-template.vm";
    private static final String JNLP_TEMPLATE_FILENAME = "template.vm";
    private static final String BUILT_IN_EXTENSION_TEMPLATE_FILENAME = "default-jnlp-extension-template.vm";
    private static final String EXTENSION_TEMPLATE_FILENAME = "extension-template.vm";
    @Parameter(property="jnlp.makeArchive", defaultValue="true")
    private boolean makeArchive;
    @Parameter(property="jnlp.attachArchive", defaultValue="true")
    private boolean attachArchive;
    @Parameter(property="jnlp.archive", defaultValue="${project.build.directory}/${project.build.finalName}.zip")
    private File archive;
    @Parameter
    private JnlpConfig jnlp;
    @Parameter
    private List<JnlpExtension> jnlpExtensions;
    @Parameter
    private Dependencies dependencies;
    @Parameter
    private String keystore;
    @Parameter(defaultValue="${basedir}", readonly=true, required=true)
    private File basedir;
    @Parameter(property="jnlp.outputJarVersions", defaultValue="false")
    private boolean outputJarVersions;
    @Component
    private MavenProjectHelper projectHelper;
    private List<Artifact> packagedJnlpArtifacts = new ArrayList<Artifact>();
    private Map<JnlpExtension, List<Artifact>> extensionsJnlpArtifacts = new HashMap<JnlpExtension, List<Artifact>>();
    private Artifact artifactWithMainClass;

    public void execute() throws MojoExecutionException {
        boolean withExtensions = CollectionUtils.isNotEmpty(this.jnlpExtensions);
        if (withExtensions) {
            this.prepareExtensions();
            this.findDefaultJnlpExtensionTemplateURL();
        }
        this.checkInput();
        this.findDefaultJnlpTemplateURL();
        this.getLog().debug((CharSequence)("using work directory " + this.getWorkDirectory()));
        this.getLog().debug((CharSequence)("using library directory " + this.getLibDirectory()));
        IOUtil ioUtil = this.getIoUtil();
        ioUtil.makeDirectoryIfNecessary(this.getWorkDirectory());
        ioUtil.makeDirectoryIfNecessary(this.getLibDirectory());
        try {
            ioUtil.copyResources(this.getResourcesDirectory(), this.getWorkDirectory());
            this.artifactWithMainClass = null;
            this.processDependencies();
            if (withExtensions) {
                this.processExtensionsDependencies();
            }
            if (this.artifactWithMainClass == null) {
                throw new MojoExecutionException("didn't find artifact with main class: " + this.jnlp.getMainClass() + ". Did you specify it? ");
            }
            this.processNativeLibs();
            if ((this.isPack200() || this.getSign() != null) && this.getLog().isDebugEnabled()) {
                this.logCollection("Some dependencies may be skipped. Here's the list of the artifacts that should be signed/packed: ", this.getModifiedJnlpArtifacts());
            }
            this.signOrRenameJars();
            this.generateJnlpFile(this.getWorkDirectory());
            if (withExtensions) {
                this.generateJnlpExtensionsFile(this.getWorkDirectory());
            }
            if (this.makeArchive) {
                ioUtil.makeDirectoryIfNecessary(this.archive.getParentFile());
                ioUtil.deleteFile(this.archive);
                this.verboseLog("Will create archive at location: " + this.archive);
                ioUtil.createArchive(this.getWorkDirectory(), this.archive);
                if (this.attachArchive) {
                    this.projectHelper.attachArtifact(this.getProject(), "zip", this.archive);
                }
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failure to run the plugin: ", e);
        }
    }

    protected JnlpConfig getJnlp() {
        return this.jnlp;
    }

    protected Dependencies getDependencies() {
        return this.dependencies;
    }

    void checkDependencies() throws MojoExecutionException {
        if (this.dependencies == null) {
            return;
        }
        boolean failed = false;
        Set artifacts = this.getProject().getArtifacts();
        this.getLog().debug((CharSequence)("artifacts: " + artifacts.size()));
        if (this.dependencies.getIncludes() != null && !this.dependencies.getIncludes().isEmpty()) {
            failed = this.checkDependencies(this.dependencies.getIncludes(), artifacts);
        }
        if (this.dependencies.getExcludes() != null && !this.dependencies.getExcludes().isEmpty()) {
            boolean bl = failed = this.checkDependencies(this.dependencies.getExcludes(), artifacts) || failed;
        }
        if (failed) {
            throw new MojoExecutionException("At least one specified dependency is incorrect. Review your project configuration.");
        }
    }

    private boolean checkDependencies(List<String> patterns, Collection<Artifact> artifacts) {
        if (this.dependencies == null) {
            return false;
        }
        boolean failed = false;
        for (String pattern : patterns) {
            failed = this.ensurePatternMatchesAtLeastOneArtifact(pattern, artifacts) || failed;
        }
        return failed;
    }

    private boolean ensurePatternMatchesAtLeastOneArtifact(String pattern, Collection<Artifact> artifacts) {
        ArrayList<String> onePatternList = new ArrayList<String>();
        onePatternList.add(pattern);
        IncludesArtifactFilter filter = new IncludesArtifactFilter(onePatternList);
        boolean noMatch = true;
        for (Artifact artifact : artifacts) {
            this.getLog().debug((CharSequence)("checking pattern: " + pattern + " against " + artifact));
            if (!filter.include(artifact)) continue;
            noMatch = false;
            break;
        }
        if (noMatch) {
            this.getLog().error((CharSequence)("pattern: " + pattern + " doesn't match any artifact."));
        }
        return noMatch;
    }

    private void processDependencies() throws MojoExecutionException {
        this.processDependency(this.getProject().getArtifact());
        AndArtifactFilter filter = new AndArtifactFilter();
        if (this.dependencies != null && this.dependencies.getIncludes() != null && !this.dependencies.getIncludes().isEmpty()) {
            filter.add((ArtifactFilter)new IncludesArtifactFilter(this.dependencies.getIncludes()));
        }
        if (this.dependencies != null && this.dependencies.getExcludes() != null && !this.dependencies.getExcludes().isEmpty()) {
            filter.add((ArtifactFilter)new ExcludesArtifactFilter(this.dependencies.getExcludes()));
        }
        Set artifacts = this.isExcludeTransitive() ? this.getProject().getDependencyArtifacts() : this.getProject().getArtifacts();
        for (Artifact artifact : artifacts) {
            if (!filter.include(artifact)) continue;
            this.processDependency(artifact);
        }
    }

    private void processDependency(Artifact artifact) throws MojoExecutionException {
        if (!("system".equals(artifact.getScope()) || "provided".equals(artifact.getScope()) || "test".equals(artifact.getScope()))) {
            String type = artifact.getType();
            if ("jar".equals(type) || "ejb-client".equals(type)) {
                boolean copied;
                File toCopy = artifact.getFile();
                if (toCopy == null) {
                    this.getLog().error((CharSequence)("artifact with no file: " + artifact));
                    this.getLog().error((CharSequence)("artifact download url: " + artifact.getDownloadUrl()));
                    this.getLog().error((CharSequence)("artifact repository: " + artifact.getRepository()));
                    this.getLog().error((CharSequence)("artifact repository: " + artifact.getVersion()));
                    throw new IllegalStateException("artifact " + artifact + " has no matching file, why? Check the logs...");
                }
                String name = toCopy.getName();
                String extension = name.substring(name.lastIndexOf(46));
                if (this.outputJarVersions) {
                    name = artifact.getArtifactId() + "__V" + artifact.getVersion() + extension;
                }
                if (copied = this.copyJarAsUnprocessedToDirectoryIfNecessary(toCopy, this.getLibDirectory(), name)) {
                    this.getModifiedJnlpArtifacts().add(name.substring(0, name.lastIndexOf(46)));
                }
                this.packagedJnlpArtifacts.add(artifact);
                boolean containsMainClass = this.getArtifactUtil().artifactContainsClass(artifact, this.jnlp.getMainClass());
                if (containsMainClass) {
                    if (this.artifactWithMainClass == null) {
                        this.artifactWithMainClass = artifact;
                        this.getLog().debug((CharSequence)("Found main jar. Artifact " + this.artifactWithMainClass + " contains the main class: " + this.jnlp.getMainClass()));
                    } else {
                        this.getLog().warn((CharSequence)("artifact " + artifact + " also contains the main class: " + this.jnlp.getMainClass() + ". IGNORED."));
                    }
                }
            } else {
                this.verboseLog("Skipping artifact of type " + type + " for " + this.getLibDirectory().getName());
            }
        } else {
            this.verboseLog("Skipping artifact of scope " + artifact.getScope() + " for " + this.getLibDirectory().getName());
        }
    }

    private void generateJnlpFile(File outputDirectory) throws MojoExecutionException {
        File templateFile;
        File templateDirectory;
        if (StringUtils.isBlank((String)this.jnlp.getOutputFile())) {
            this.getLog().debug((CharSequence)"Jnlp output file name not specified. Using default output file name: launch.jnlp.");
            this.jnlp.setOutputFile("launch.jnlp");
        }
        File jnlpOutputFile = new File(outputDirectory, this.jnlp.getOutputFile());
        if (StringUtils.isNotBlank((String)this.jnlp.getInputTemplateResourcePath())) {
            templateDirectory = new File(this.jnlp.getInputTemplateResourcePath());
            this.getLog().debug((CharSequence)("Use jnlp directory : " + templateDirectory));
        } else {
            templateDirectory = this.getTemplateDirectory();
            this.getLog().debug((CharSequence)("Use default template directory : " + templateDirectory));
        }
        if (StringUtils.isBlank((String)this.jnlp.getInputTemplate())) {
            this.getLog().debug((CharSequence)"Jnlp template file name not specified. Checking if default output file name exists: template.vm");
            templateFile = new File(templateDirectory, JNLP_TEMPLATE_FILENAME);
            if (templateFile.isFile()) {
                this.jnlp.setInputTemplate(JNLP_TEMPLATE_FILENAME);
            } else {
                this.getLog().debug((CharSequence)"Jnlp template file not found in default location. Using inbuilt one.");
            }
        } else {
            templateFile = new File(templateDirectory, this.jnlp.getInputTemplate());
            if (!templateFile.isFile()) {
                throw new MojoExecutionException("The specified JNLP template does not exist: [" + templateFile + "]");
            }
        }
        String templateFileName = this.jnlp.getInputTemplate();
        GeneratorTechnicalConfig generatorTechnicalConfig = new GeneratorTechnicalConfig(this.getProject(), templateDirectory, BUILT_IN_JNLP_TEMPLATE_FILENAME, jnlpOutputFile, templateFileName, this.jnlp.getMainClass(), this.getWebstartJarURLForVelocity(), this.getEncoding());
        GeneratorConfig generatorConfig = new GeneratorConfig(this.getLibPath(), this.isPack200(), this.outputJarVersions, this.artifactWithMainClass, this.getDependencyFilenameStrategy(), this.packagedJnlpArtifacts, this.jnlpExtensions, this.getCodebase(), this.jnlp);
        Generator jnlpGenerator = new Generator(this.getLog(), generatorTechnicalConfig, generatorConfig);
        try {
            jnlpGenerator.generate();
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)e.toString());
            throw new MojoExecutionException("Could not generate the JNLP deployment descriptor", e);
        }
    }

    private void processNativeLibs() {
    }

    private void logCollection(String prefix, Collection collection) {
        this.getLog().debug((CharSequence)(prefix + " " + collection));
        if (collection == null) {
            return;
        }
        for (Object aCollection : collection) {
            this.getLog().debug((CharSequence)(prefix + aCollection));
        }
    }

    private void checkInput() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("basedir " + this.basedir));
        this.getLog().debug((CharSequence)("gzip " + this.isGzip()));
        this.getLog().debug((CharSequence)("pack200 " + this.isPack200()));
        this.getLog().debug((CharSequence)("project " + this.getProject()));
        this.getLog().debug((CharSequence)("verbose " + this.isVerbose()));
        this.checkDependencyFilenameStrategy();
        this.checkPack200();
        this.checkDependencies();
        if (this.jnlp != null && this.jnlp.getResources() != null) {
            throw new MojoExecutionException("The <jnlp><resources> configuration element is obsolete. Use <resourcesDirectory> instead.");
        }
    }

    private void checkExtension(JnlpExtension extension) throws MojoExecutionException {
        if (StringUtils.isEmpty((String)extension.getName())) {
            throw new MojoExecutionException("JnlpExtension name is mandatory. Review your project configuration.");
        }
        if (StringUtils.isEmpty((String)extension.getVendor())) {
            throw new MojoExecutionException("JnlpExtension vendor is mandatory. Review your project configuration.");
        }
        if (StringUtils.isEmpty((String)extension.getTitle())) {
            throw new MojoExecutionException("JnlpExtension name is title. Review your project configuration.");
        }
        if (extension.getIncludes() == null || extension.getIncludes().isEmpty()) {
            throw new MojoExecutionException("JnlpExtension need at least one include artifact. Review your project configuration.");
        }
    }

    private void prepareExtensions() throws MojoExecutionException {
        ArrayList<String> includes = new ArrayList<String>();
        for (JnlpExtension extension : this.jnlpExtensions) {
            this.checkExtension(extension);
            for (String o : extension.getIncludes()) {
                includes.add(o.trim());
            }
            if (extension.getOutputFile() != null && extension.getOutputFile().length() != 0) continue;
            String name = extension.getName() + ".jnlp";
            this.verboseLog("Jnlp extension output file name not specified. Using default output file name: " + name + ".");
            extension.setOutputFile(name);
        }
        if (this.dependencies == null) {
            this.dependencies = new Dependencies();
        }
        if (this.dependencies.getExcludes() == null) {
            this.dependencies.setExcludes(new ArrayList<String>());
        }
        this.dependencies.getExcludes().addAll(includes);
    }

    private void processExtensionsDependencies() throws MojoExecutionException {
        Set artifacts = this.isExcludeTransitive() ? this.getProject().getDependencyArtifacts() : this.getProject().getArtifacts();
        for (JnlpExtension extension : this.jnlpExtensions) {
            IncludesArtifactFilter filter = new IncludesArtifactFilter(extension.getIncludes());
            for (Artifact artifact : artifacts) {
                if (!filter.include(artifact)) continue;
                this.processExtensionDependency(extension, artifact);
            }
        }
    }

    private void processExtensionDependency(JnlpExtension extension, Artifact artifact) throws MojoExecutionException {
        if (!("system".equals(artifact.getScope()) || "provided".equals(artifact.getScope()) || "test".equals(artifact.getScope()))) {
            String type = artifact.getType();
            if ("jar".equals(type) || "ejb-client".equals(type)) {
                File toCopy = artifact.getFile();
                if (toCopy == null) {
                    this.getLog().error((CharSequence)("artifact with no file: " + artifact));
                    this.getLog().error((CharSequence)("artifact download url: " + artifact.getDownloadUrl()));
                    this.getLog().error((CharSequence)("artifact repository: " + artifact.getRepository()));
                    this.getLog().error((CharSequence)("artifact repository: " + artifact.getVersion()));
                    throw new IllegalStateException("artifact " + artifact + " has no matching file, why? Check the logs...");
                }
                boolean jarSigned = this.isJarSigned(toCopy);
                if (!jarSigned) {
                    throw new IllegalStateException("artifact " + artifact + " must be signed as part of an extension..");
                }
                boolean copied = this.getIoUtil().copyFileToDirectoryIfNecessary(toCopy, this.getLibDirectory());
                if (copied) {
                    this.verboseLog("copy extension artifact " + toCopy);
                } else {
                    this.verboseLog("already up to date artifact " + toCopy);
                }
                List<Artifact> deps = this.extensionsJnlpArtifacts.get(extension);
                if (deps == null) {
                    deps = new ArrayList<Artifact>();
                    this.extensionsJnlpArtifacts.put(extension, deps);
                }
                deps.add(artifact);
            } else {
                this.verboseLog("Skipping artifact of type " + type + " for " + this.getLibDirectory().getName());
            }
        } else {
            this.verboseLog("Skipping artifact of scope " + artifact.getScope() + " for " + this.getLibDirectory().getName());
        }
    }

    private void generateJnlpExtensionsFile(File outputDirectory) throws MojoExecutionException {
        for (JnlpExtension jnlpExtension : this.jnlpExtensions) {
            this.generateJnlpExtensionFile(outputDirectory, jnlpExtension);
        }
    }

    private void generateJnlpExtensionFile(File outputDirectory, JnlpExtension extension) throws MojoExecutionException {
        File templateFile;
        File templateDirectory;
        File jnlpOutputFile = new File(outputDirectory, extension.getOutputFile());
        if (StringUtils.isNotBlank((String)extension.getInputTemplateResourcePath())) {
            templateDirectory = new File(extension.getInputTemplateResourcePath());
        } else {
            templateDirectory = this.getTemplateDirectory();
            this.getLog().debug((CharSequence)("Use default jnlp directory : " + templateDirectory));
        }
        if (StringUtils.isBlank((String)extension.getInputTemplate())) {
            this.getLog().debug((CharSequence)"Jnlp extension template file name not specified. Checking if default output file name exists: extension-template.vm");
            templateFile = new File(templateDirectory, EXTENSION_TEMPLATE_FILENAME);
            if (templateFile.isFile()) {
                extension.setInputTemplate(EXTENSION_TEMPLATE_FILENAME);
            } else {
                this.getLog().debug((CharSequence)"Jnlp extension template file not found in default location. Using inbuilt one.");
            }
        } else {
            templateFile = new File(templateDirectory, extension.getInputTemplate());
            if (!templateFile.isFile()) {
                throw new MojoExecutionException("The specified JNLP extension template does not exist: [" + templateFile + "]");
            }
        }
        String templateFileName = extension.getInputTemplate();
        GeneratorTechnicalConfig generatorTechnicalConfig = new GeneratorTechnicalConfig(this.getProject(), templateDirectory, BUILT_IN_EXTENSION_TEMPLATE_FILENAME, jnlpOutputFile, templateFileName, this.getJnlp().getMainClass(), this.getWebstartJarURLForVelocity(), this.getEncoding());
        ExtensionGeneratorConfig extensionGeneratorConfig = new ExtensionGeneratorConfig(this.getLibPath(), this.isPack200(), this.outputJarVersions, this.artifactWithMainClass, this.getDependencyFilenameStrategy(), this.extensionsJnlpArtifacts, this.getCodebase(), extension);
        ExtensionGenerator jnlpGenerator = new ExtensionGenerator(this.getLog(), generatorTechnicalConfig, extensionGeneratorConfig);
        try {
            jnlpGenerator.generate();
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)e.toString());
            throw new MojoExecutionException("Could not generate the JNLP deployment descriptor", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Dependencies {
        private List<String> includes;
        private List<String> excludes;

        public List<String> getIncludes() {
            return this.includes;
        }

        public void setIncludes(List<String> includes) {
            this.includes = includes;
        }

        public List<String> getExcludes() {
            return this.excludes;
        }

        public void setExcludes(List<String> excludes) {
            this.excludes = excludes;
        }
    }
}

