/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.reporting.model.io.xpp3;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.codehaus.mojo.versions.reporting.model.DependencyInfo;
import org.codehaus.mojo.versions.reporting.model.DependencyReportSummary;
import org.codehaus.mojo.versions.reporting.model.DependencyUpdatesReport;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class DependencyUpdatesReportXpp3Writer {
    private static final String NAMESPACE = null;
    private String fileComment = null;

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public void write(Writer writer, DependencyUpdatesReport dependencyUpdatesReport) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(dependencyUpdatesReport.getModelEncoding(), null);
        this.writeDependencyUpdatesReport(dependencyUpdatesReport, "DependencyUpdatesReport", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    public void write(OutputStream stream, DependencyUpdatesReport dependencyUpdatesReport) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(stream, dependencyUpdatesReport.getModelEncoding());
        serializer.startDocument(dependencyUpdatesReport.getModelEncoding(), null);
        this.writeDependencyUpdatesReport(dependencyUpdatesReport, "DependencyUpdatesReport", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeDependencyInfo(DependencyInfo dependencyInfo, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (dependencyInfo.getGroupId() != null) {
            serializer.startTag(NAMESPACE, "groupId").text(dependencyInfo.getGroupId()).endTag(NAMESPACE, "groupId");
        }
        if (dependencyInfo.getArtifactId() != null) {
            serializer.startTag(NAMESPACE, "artifactId").text(dependencyInfo.getArtifactId()).endTag(NAMESPACE, "artifactId");
        }
        if (dependencyInfo.getScope() != null) {
            serializer.startTag(NAMESPACE, "scope").text(dependencyInfo.getScope()).endTag(NAMESPACE, "scope");
        }
        if (dependencyInfo.getClassifier() != null) {
            serializer.startTag(NAMESPACE, "classifier").text(dependencyInfo.getClassifier()).endTag(NAMESPACE, "classifier");
        }
        if (dependencyInfo.getType() != null) {
            serializer.startTag(NAMESPACE, "type").text(dependencyInfo.getType()).endTag(NAMESPACE, "type");
        }
        if (dependencyInfo.getCurrentVersion() != null) {
            serializer.startTag(NAMESPACE, "currentVersion").text(dependencyInfo.getCurrentVersion()).endTag(NAMESPACE, "currentVersion");
        }
        if (dependencyInfo.getLastVersion() != null) {
            serializer.startTag(NAMESPACE, "lastVersion").text(dependencyInfo.getLastVersion()).endTag(NAMESPACE, "lastVersion");
        }
        if (dependencyInfo.getAny() != null && dependencyInfo.getAny().size() > 0) {
            serializer.startTag(NAMESPACE, "any");
            for (String any : dependencyInfo.getAny()) {
                serializer.startTag(NAMESPACE, "any").text(any).endTag(NAMESPACE, "any");
            }
            serializer.endTag(NAMESPACE, "any");
        }
        if (dependencyInfo.getIncrementals() != null && dependencyInfo.getIncrementals().size() > 0) {
            serializer.startTag(NAMESPACE, "incrementals");
            for (String incremental : dependencyInfo.getIncrementals()) {
                serializer.startTag(NAMESPACE, "incremental").text(incremental).endTag(NAMESPACE, "incremental");
            }
            serializer.endTag(NAMESPACE, "incrementals");
        }
        if (dependencyInfo.getMinors() != null && dependencyInfo.getMinors().size() > 0) {
            serializer.startTag(NAMESPACE, "minors");
            for (String minor : dependencyInfo.getMinors()) {
                serializer.startTag(NAMESPACE, "minor").text(minor).endTag(NAMESPACE, "minor");
            }
            serializer.endTag(NAMESPACE, "minors");
        }
        if (dependencyInfo.getMajors() != null && dependencyInfo.getMajors().size() > 0) {
            serializer.startTag(NAMESPACE, "majors");
            for (String major : dependencyInfo.getMajors()) {
                serializer.startTag(NAMESPACE, "major").text(major).endTag(NAMESPACE, "major");
            }
            serializer.endTag(NAMESPACE, "majors");
        }
        if (dependencyInfo.getStatus() != null) {
            serializer.startTag(NAMESPACE, "status").text(dependencyInfo.getStatus()).endTag(NAMESPACE, "status");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeDependencyReportSummary(DependencyReportSummary dependencyReportSummary, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (dependencyReportSummary.getUsingLastVersion() != null) {
            serializer.startTag(NAMESPACE, "usingLastVersion").text(dependencyReportSummary.getUsingLastVersion()).endTag(NAMESPACE, "usingLastVersion");
        }
        if (dependencyReportSummary.getNextVersionAvailable() != null) {
            serializer.startTag(NAMESPACE, "nextVersionAvailable").text(dependencyReportSummary.getNextVersionAvailable()).endTag(NAMESPACE, "nextVersionAvailable");
        }
        if (dependencyReportSummary.getNextIncrementalAvailable() != null) {
            serializer.startTag(NAMESPACE, "nextIncrementalAvailable").text(dependencyReportSummary.getNextIncrementalAvailable()).endTag(NAMESPACE, "nextIncrementalAvailable");
        }
        if (dependencyReportSummary.getNextMinorAvailable() != null) {
            serializer.startTag(NAMESPACE, "nextMinorAvailable").text(dependencyReportSummary.getNextMinorAvailable()).endTag(NAMESPACE, "nextMinorAvailable");
        }
        if (dependencyReportSummary.getNextMajorAvailable() != null) {
            serializer.startTag(NAMESPACE, "nextMajorAvailable").text(dependencyReportSummary.getNextMajorAvailable()).endTag(NAMESPACE, "nextMajorAvailable");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeDependencyUpdatesReport(DependencyUpdatesReport dependencyUpdatesReport, String tagName, XmlSerializer serializer) throws IOException {
        if (this.fileComment != null) {
            serializer.comment(this.fileComment);
        }
        serializer.setPrefix("", "https://www.mojohaus.org/VERSIONS/DEPENDENCY-UPDATES-REPORT/2.0.0");
        serializer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        serializer.startTag(NAMESPACE, tagName);
        serializer.attribute("", "xsi:schemaLocation", "https://www.mojohaus.org/VERSIONS/DEPENDENCY-UPDATES-REPORT/2.0.0 https://www.mojohaus.org/versions-maven-plugin/xsd/dependency-updates-report-2.0.0.xsd");
        if (dependencyUpdatesReport.getSummary() != null) {
            this.writeDependencyReportSummary(dependencyUpdatesReport.getSummary(), "summary", serializer);
        }
        if (dependencyUpdatesReport.getDependencyManagements() != null && dependencyUpdatesReport.getDependencyManagements().size() > 0) {
            serializer.startTag(NAMESPACE, "dependencyManagements");
            for (DependencyInfo o : dependencyUpdatesReport.getDependencyManagements()) {
                this.writeDependencyInfo(o, "dependencyManagement", serializer);
            }
            serializer.endTag(NAMESPACE, "dependencyManagements");
        }
        if (dependencyUpdatesReport.getDependencies() != null && dependencyUpdatesReport.getDependencies().size() > 0) {
            serializer.startTag(NAMESPACE, "dependencies");
            for (DependencyInfo o : dependencyUpdatesReport.getDependencies()) {
                this.writeDependencyInfo(o, "dependency", serializer);
            }
            serializer.endTag(NAMESPACE, "dependencies");
        }
        serializer.endTag(NAMESPACE, tagName);
    }
}

