/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.shared.keytool;

import java.io.File;
import org.codehaus.mojo.shared.keytool.CommandLineConfigurationException;
import org.codehaus.mojo.shared.keytool.KeyToolRequest;
import org.codehaus.mojo.shared.keytool.KeyToolRequestWithKeyStoreAndAliasParameters;
import org.codehaus.mojo.shared.keytool.KeyToolRequestWithKeyStoreParameters;
import org.codehaus.mojo.shared.keytool.requests.KeyToolChangeAliasRequest;
import org.codehaus.mojo.shared.keytool.requests.KeyToolChangeKeyPasswordRequest;
import org.codehaus.mojo.shared.keytool.requests.KeyToolChangeStorePasswordRequest;
import org.codehaus.mojo.shared.keytool.requests.KeyToolDeleteRequest;
import org.codehaus.mojo.shared.keytool.requests.KeyToolExportCertificateRequest;
import org.codehaus.mojo.shared.keytool.requests.KeyToolGenerateCertificateRequest;
import org.codehaus.mojo.shared.keytool.requests.KeyToolGenerateCertificateRequestRequest;
import org.codehaus.mojo.shared.keytool.requests.KeyToolGenerateKeyPairRequest;
import org.codehaus.mojo.shared.keytool.requests.KeyToolGenerateSecretKeyRequest;
import org.codehaus.mojo.shared.keytool.requests.KeyToolImportCertificateRequest;
import org.codehaus.mojo.shared.keytool.requests.KeyToolImportKeystoreRequest;
import org.codehaus.mojo.shared.keytool.requests.KeyToolListRequest;
import org.codehaus.mojo.shared.keytool.requests.KeyToolPrintCRLFileRequest;
import org.codehaus.mojo.shared.keytool.requests.KeyToolPrintCertificateRequest;
import org.codehaus.mojo.shared.keytool.requests.KeyToolPrintCertificateRequestRequest;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class KeyToolCommandLineBuilder {
    private static final Logger DEFAULT_LOGGER = new ConsoleLogger(0, KeyToolCommandLineBuilder.class.getName());
    private Logger logger = DEFAULT_LOGGER;
    private String keyToolFile;

    public Commandline build(KeyToolRequest request) throws CommandLineConfigurationException {
        String[] arguments;
        this.checkRequiredState();
        Commandline cli = new Commandline();
        cli.setExecutable(this.keyToolFile);
        cli.setWorkingDirectory(request.getWorkingDirectory());
        this.addArg(cli, request.getKeytoolCommand());
        this.addArgIfTrue(cli, "-v", request.isVerbose());
        if (request instanceof KeyToolRequestWithKeyStoreParameters) {
            this.buildWithProviders((KeyToolRequestWithKeyStoreParameters)request, cli);
        }
        if (request instanceof KeyToolRequestWithKeyStoreAndAliasParameters) {
            this.buildWithProviders((KeyToolRequestWithKeyStoreAndAliasParameters)request, cli);
        }
        if (request instanceof KeyToolChangeAliasRequest) {
            this.build((KeyToolChangeAliasRequest)request, cli);
        }
        if (request instanceof KeyToolChangeKeyPasswordRequest) {
            this.build((KeyToolChangeKeyPasswordRequest)request, cli);
        }
        if (request instanceof KeyToolChangeStorePasswordRequest) {
            this.build((KeyToolChangeStorePasswordRequest)request, cli);
        }
        if (request instanceof KeyToolDeleteRequest) {
            this.build((KeyToolDeleteRequest)request, cli);
        }
        if (request instanceof KeyToolExportCertificateRequest) {
            this.build((KeyToolExportCertificateRequest)request, cli);
        }
        if (request instanceof KeyToolGenerateCertificateRequest) {
            this.build((KeyToolGenerateCertificateRequest)request, cli);
        }
        if (request instanceof KeyToolGenerateCertificateRequestRequest) {
            this.build((KeyToolGenerateCertificateRequestRequest)request, cli);
        }
        if (request instanceof KeyToolGenerateKeyPairRequest) {
            this.build((KeyToolGenerateKeyPairRequest)request, cli);
        }
        if (request instanceof KeyToolGenerateSecretKeyRequest) {
            this.build((KeyToolGenerateSecretKeyRequest)request, cli);
        }
        if (request instanceof KeyToolImportCertificateRequest) {
            this.build((KeyToolImportCertificateRequest)request, cli);
        }
        if (request instanceof KeyToolImportKeystoreRequest) {
            this.build((KeyToolImportKeystoreRequest)request, cli);
        }
        if (request instanceof KeyToolListRequest) {
            this.build((KeyToolListRequest)request, cli);
        }
        if (request instanceof KeyToolPrintCertificateRequest) {
            this.build((KeyToolPrintCertificateRequest)request, cli);
        }
        if (request instanceof KeyToolPrintCertificateRequestRequest) {
            this.build((KeyToolPrintCertificateRequestRequest)request, cli);
        }
        if (request instanceof KeyToolPrintCRLFileRequest) {
            this.build((KeyToolPrintCRLFileRequest)request, cli);
        }
        if ((arguments = request.getArguments()) != null) {
            cli.addArguments(arguments);
        }
        return cli;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setKeyToolFile(String keyToolFile) {
        this.keyToolFile = keyToolFile;
    }

    protected void checkRequiredState() {
        if (this.logger == null) {
            throw new IllegalStateException("A logger instance is required.");
        }
        if (this.keyToolFile == null) {
            throw new IllegalStateException("A keyTool file is required.");
        }
    }

    protected void build(KeyToolChangeAliasRequest request, Commandline cli) {
        this.addArgIfNotEmpty(cli, "-destalias", request.getDestalias());
        this.addArgIfNotEmpty(cli, "-keypass", request.getKeypass());
    }

    protected void build(KeyToolChangeKeyPasswordRequest request, Commandline cli) {
        this.addArgIfNotEmpty(cli, "-keypass", request.getKeypass());
        this.addArgIfNotEmpty(cli, "-new", request.getNewPassword());
    }

    protected void build(KeyToolChangeStorePasswordRequest request, Commandline cli) {
        this.addArgIfNotEmpty(cli, "-new", request.getNewPassword());
    }

    protected void build(KeyToolDeleteRequest request, Commandline cli) {
    }

    protected void build(KeyToolExportCertificateRequest request, Commandline cli) {
        this.addArgIfTrue(cli, "-rfc", request.isRfc());
        this.addArgIfNotEmpty(cli, "-file", request.getFile());
    }

    protected void build(KeyToolGenerateCertificateRequest request, Commandline cli) {
        this.addArgIfTrue(cli, "-rfc", request.isRfc());
        this.addArgIfNotEmpty(cli, "-infile", request.getInfile());
        this.addArgIfNotEmpty(cli, "-outfile", request.getOutfile());
        this.addArgIfNotEmpty(cli, "-sigalg", request.getSigalg());
        this.addArgIfNotEmpty(cli, "-dname", request.getDname());
        this.addArgIfNotEmpty(cli, "-startdate", request.getStartdate());
        this.addArgIfNotEmpty(cli, "-ext", request.getExt());
        this.addArgIfNotEmpty(cli, "-validity", request.getValidity());
        this.addArgIfNotEmpty(cli, "-keypass", request.getKeypass());
    }

    protected void build(KeyToolGenerateCertificateRequestRequest request, Commandline cli) {
        this.addArgIfNotEmpty(cli, "-sigalg", request.getSigalg());
        this.addArgIfNotEmpty(cli, "-file", request.getFile());
        this.addArgIfNotEmpty(cli, "-keypass", request.getKeypass());
        this.addArgIfNotEmpty(cli, "-dname", request.getDname());
    }

    protected void build(KeyToolGenerateKeyPairRequest request, Commandline cli) {
        this.addArgIfNotEmpty(cli, "-dname", request.getDname());
        this.addArgIfNotEmpty(cli, "-keypass", request.getKeypass());
        this.addArgIfNotEmpty(cli, "-validity", request.getValidity());
        this.addArgIfNotEmpty(cli, "-keyalg", request.getKeyalg());
        this.addArgIfNotEmpty(cli, "-keysize", request.getKeysize());
        this.addArgIfNotEmpty(cli, "-sigalg", request.getSigalg());
        this.addArgIfNotEmpty(cli, "-startdate", request.getStartdate());
        this.addArgIfNotEmpty(cli, "-ext", request.getExt());
    }

    protected void build(KeyToolGenerateSecretKeyRequest request, Commandline cli) {
        this.addArgIfNotEmpty(cli, "-keypass", request.getKeypass());
        this.addArgIfNotEmpty(cli, "-keyalg", request.getKeyalg());
        this.addArgIfNotEmpty(cli, "-keysize", request.getKeysize());
    }

    protected void build(KeyToolImportCertificateRequest request, Commandline cli) {
        this.addArgIfTrue(cli, "-noprompt", request.isNoprompt());
        this.addArgIfTrue(cli, "-trustcacerts", request.isTrustcacerts());
        this.addArgIfNotEmpty(cli, "-file", request.getFile());
        this.addArgIfNotEmpty(cli, "-keypass", request.getKeypass());
    }

    protected void build(KeyToolImportKeystoreRequest request, Commandline cli) {
        this.addArgIfTrue(cli, "-noprompt", request.isNoprompt());
        this.addArgIfNotEmpty(cli, "-srcprotected", request.isSrcprotected() ? Boolean.TRUE.toString() : "");
        this.addArgIfNotEmpty(cli, "-srckeystore", request.getSrckeystore());
        this.addArgIfNotEmpty(cli, "-destkeystore", request.getDestkeystore());
        this.addArgIfNotEmpty(cli, "-srcstoretype", request.getSrcstoretype());
        this.addArgIfNotEmpty(cli, "-deststoretype", request.getDeststoretype());
        this.addArgIfNotEmpty(cli, "-srcstorepass", request.getSrckeypass());
        this.addArgIfNotEmpty(cli, "-deststorepass", request.getDestkeypass());
        this.addArgIfNotEmpty(cli, "-srcprovidername", request.getSrcprovidername());
        this.addArgIfNotEmpty(cli, "-destprovidername", request.getDestprovidername());
        this.addArgIfNotEmpty(cli, "-srcalias", request.getSrcalias());
        this.addArgIfNotEmpty(cli, "-destalias", request.getDestalias());
        this.addArgIfNotEmpty(cli, "-srckeypass", request.getSrckeypass());
        this.addArgIfNotEmpty(cli, "-destkeypass", request.getDestkeypass());
        this.addArgIfNotEmpty(cli, "-providerclass", request.getProviderclass());
        this.addArgIfNotEmpty(cli, "-providerarg", request.getProviderarg());
        this.addArgIfNotEmpty(cli, "-providerpath", request.getProviderpath());
    }

    protected void build(KeyToolListRequest request, Commandline cli) {
        this.addArgIfTrue(cli, "-rfc", request.isRfc());
    }

    protected void build(KeyToolPrintCertificateRequest request, Commandline cli) {
        this.addArgIfTrue(cli, "-rfc", request.isRfc());
        this.addArgIfNotEmpty(cli, "-file", request.getFile());
        this.addArgIfNotEmpty(cli, "-sslserver", request.getSslserver());
        this.addArgIfNotEmpty(cli, "-jarfile", request.getJarfile());
    }

    protected void build(KeyToolPrintCertificateRequestRequest request, Commandline cli) {
        this.addArgIfNotEmpty(cli, "-file", request.getFile());
    }

    protected void build(KeyToolPrintCRLFileRequest request, Commandline cli) {
        this.addArgIfNotEmpty(cli, "-file", request.getFile());
    }

    protected void buildWithProviders(KeyToolRequestWithKeyStoreParameters request, Commandline cli) {
        this.addArgIfNotEmpty(cli, "-keystore", request.getKeystore());
        this.addArgIfNotEmpty(cli, "-storepass", request.getStorepass());
        this.addArgIfNotEmpty(cli, "-storetype", request.getStoretype());
        this.addArgIfNotEmpty(cli, "-providername", request.getProvidername());
        this.addArgIfNotEmpty(cli, "-providerclass", request.getProviderclass());
        this.addArgIfNotEmpty(cli, "-providerarg", request.getProviderarg());
        this.addArgIfNotEmpty(cli, "-providerpath", request.getProviderpath());
    }

    protected void buildWithProviders(KeyToolRequestWithKeyStoreAndAliasParameters request, Commandline cli) {
        this.addArgIfNotEmpty(cli, "-protected", request.isPasswordProtected() ? Boolean.TRUE.toString() : "");
        this.addArgIfNotEmpty(cli, "-alias", request.getAlias());
    }

    protected void addArgIfNotEmpty(Commandline cli, String key, String value) {
        if (!StringUtils.isEmpty((String)value)) {
            this.addArg(cli, key);
            this.addArg(cli, value);
        }
    }

    protected void addArgIfNotEmpty(Commandline cli, String key, File value) {
        if (value != null) {
            this.addArg(cli, key);
            this.addArg(cli, value);
        }
    }

    protected void addArgIfTrue(Commandline cli, String key, boolean value) {
        if (value) {
            this.addArg(cli, key);
        }
    }

    protected void addArg(Commandline cli, String value) {
        cli.createArg().setValue(value);
    }

    protected void addArg(Commandline cli, File value) {
        cli.createArg().setFile(value);
    }
}

