/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.scmchangelog.scm.svn;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmRevision;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.list.ListScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.mojo.scmchangelog.changelog.Release;
import org.codehaus.mojo.scmchangelog.changelog.log.grammar.GrammarEnum;
import org.codehaus.mojo.scmchangelog.scm.svn.SvnTargetEnum;
import org.codehaus.mojo.scmchangelog.scm.util.ScmAdapter;
import org.codehaus.mojo.scmchangelog.scm.util.ScmTarget;
import org.codehaus.mojo.scmchangelog.tags.Tag;

public class SvnScmAdapter
extends ScmAdapter {
    public SvnScmAdapter(ScmManager currentManager, GrammarEnum currentGrammar) {
        super(currentManager, currentGrammar);
    }

    public List getListOfReleases(ScmRepository repository, ScmFileSet fileSet) throws MojoExecutionException, ScmException {
        ListScmResult result = this.manager.list(repository, fileSet, false, this.getScmVersion(SvnTargetEnum.TAG, ""));
        List tags = result.getFiles();
        this.getLogger().info((CharSequence)tags.toString());
        ArrayList<Release> releases = new ArrayList<Release>(10);
        Iterator iter = tags.iterator();
        while (iter.hasNext()) {
            Tag tag = (Tag)iter.next();
            ChangeLogScmResult logs = this.manager.changeLog(repository, fileSet, this.getScmVersion(SvnTargetEnum.TRUNK, tag.getStartRevision()), this.getScmVersion(SvnTargetEnum.TRUNK, tag.getEndRevision()), "");
            if (logs.getChangeLog() == null) continue;
            Release release = new Release(tag, logs.getChangeLog().getChangeSets());
            releases.add(release);
        }
        String endRevision = "0";
        if (!tags.isEmpty()) {
            endRevision = ((Tag)tags.get(tags.size() - 1)).getEndRevision();
        }
        this.getLogger().info((CharSequence)("End revision : " + endRevision));
        Tag trunk = new Tag("trunk");
        trunk.setStartRevision(endRevision);
        trunk.setDate(new Date());
        trunk.setEndRevision(null);
        ChangeLogScmResult logs = this.manager.changeLog(repository, fileSet, this.getScmVersion(SvnTargetEnum.TRUNK, endRevision), null, "");
        if (logs.getChangeLog() != null) {
            Release release = new Release(trunk, logs.getChangeLog().getChangeSets());
            releases.add(release);
        }
        Collections.reverse(releases);
        return releases;
    }

    public ScmVersion getScmVersion(ScmTarget versionType, String version) throws MojoExecutionException {
        if (SvnTargetEnum.TAG.equals(versionType)) {
            return new ScmTag(version);
        }
        if (SvnTargetEnum.BRANCH.equals(versionType)) {
            return new ScmBranch(version);
        }
        if (SvnTargetEnum.TRUNK.equals(versionType)) {
            return new ScmRevision(version);
        }
        throw new MojoExecutionException("Unknown version type : " + versionType);
    }
}

