/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.scmchangelog.changelog.log.grammar;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.codehaus.mojo.scmchangelog.changelog.log.Issue;
import org.codehaus.mojo.scmchangelog.changelog.log.Message;
import org.codehaus.mojo.scmchangelog.changelog.log.OperationTypeEnum;
import org.codehaus.mojo.scmchangelog.changelog.log.grammar.AbstractScmGrammar;

public abstract class AbstractRegexpScmGrammar
extends AbstractScmGrammar {
    public Message extractMessage(String content) {
        String expression = content;
        ArrayList issues = new ArrayList();
        expression = this.computeIssues(OperationTypeEnum.FIX, expression, issues);
        expression = this.computeIssues(OperationTypeEnum.ADD, expression, issues);
        expression = this.computeIssues(OperationTypeEnum.UPDATE, expression, issues);
        if ((expression = this.computeIssues(OperationTypeEnum.REMOVE, expression, issues)).startsWith(this.getIssueSeparator())) {
            expression = expression.substring(2);
        }
        return new Message(expression.trim(), issues);
    }

    public boolean hasMessage(String content) {
        return this.getAddCleaner(content).find() || this.getFixCleaner(content).find() || this.getRemoveCleaner(content).find() || this.getUpdateCleaner(content).find();
    }

    protected String computeIssues(OperationTypeEnum type, String expression, List issues) {
        String tempExpression = expression;
        Matcher matcher = this.getFinder(type, expression);
        boolean hasMore = matcher.find();
        while (hasMore) {
            String element = matcher.group();
            Matcher cleaner = this.getCleaner(type, element);
            cleaner.find();
            Issue issue = new Issue(element.substring(cleaner.end(), element.length() - 1), type);
            issues.add(issue);
            tempExpression = tempExpression.substring(0, matcher.start()) + this.getIssueSeparator() + tempExpression.substring(matcher.end(), tempExpression.length());
            matcher = this.getFinder(type, tempExpression);
            hasMore = matcher.find();
        }
        return tempExpression;
    }

    protected Matcher getCleaner(OperationTypeEnum type, String expression) {
        if (OperationTypeEnum.ADD.equals(type)) {
            return this.getAddCleaner(expression);
        }
        if (OperationTypeEnum.FIX.equals(type)) {
            return this.getFixCleaner(expression);
        }
        if (OperationTypeEnum.UPDATE.equals(type)) {
            return this.getUpdateCleaner(expression);
        }
        if (OperationTypeEnum.REMOVE.equals(type)) {
            return this.getRemoveCleaner(expression);
        }
        return this.getRemoveCleaner(expression);
    }

    protected Matcher getFinder(OperationTypeEnum type, String expression) {
        if (OperationTypeEnum.ADD.equals(type)) {
            return this.getAddMatcher(expression);
        }
        if (OperationTypeEnum.FIX.equals(type)) {
            return this.getFixMatcher(expression);
        }
        if (OperationTypeEnum.UPDATE.equals(type)) {
            return this.getUpdateMatcher(expression);
        }
        if (OperationTypeEnum.REMOVE.equals(type)) {
            return this.getRemoveMatcher(expression);
        }
        return this.getRemoveMatcher(expression);
    }

    public String getIssueSeparator() {
        return "\r\n";
    }

    public abstract Matcher getFixCleaner(String var1);

    public abstract Matcher getUpdateCleaner(String var1);

    public abstract Matcher getAddCleaner(String var1);

    public abstract Matcher getRemoveCleaner(String var1);

    public abstract Matcher getFixMatcher(String var1);

    public abstract Matcher getAddMatcher(String var1);

    public abstract Matcher getRemoveMatcher(String var1);

    public abstract Matcher getUpdateMatcher(String var1);
}

