/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.project.archive;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:project-sources-maven-plugin:1.0-alpha-6", 0);
        this.append(sb, "", 0);
        this.append(sb, "Project Sources Plugin 1.0-alpha-6", 0);
        this.append(sb, "Plugin used to manage source archives for a project, including resolving, creating, unpacking, and pushing to the repository.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 5 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "deploy-project-sources".equals(this.goal)) {
            this.append(sb, "project-sources:deploy-project-sources", 0);
            this.append(sb, "Deploy the project-sources artifact to the remote repository. The project-sources artifact should already have been created by the package-project-sources mojo.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "sourceArtifactClassifier (Default: project-sources)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceArtifactType (Default: zip)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "project-sources:help", 0);
            this.append(sb, "Display help information on project-sources-maven-plugin. Call\n\u00a0\u00a0mvn\u00a0project-sources:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "package-project-sources".equals(this.goal)) {
            this.append(sb, "project-sources:package-project-sources", 0);
            this.append(sb, "Package up the current project's sources into an archive, skipping the patch directory and the current build output directory (usually /target). Then, create an artifact using the base version of the current project (without any release number), and assign the newly created project-sources archive to the artifact's file attribute. If the project sources originated from a tarball or other archive, simply set the artifact's file to the original archive location.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "List of exclusion patterns (using Ant-style path expressions) to limit the contents of the project-sources archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includePatchDirectory (Default: false)", 2);
                this.append(sb, "Whether the patch directory in the project's working directory should be included in the project-sources artifact. Patches are normally handled separately, to enable successive releases based on the same source archive, but with different patch sets. Unless you know what you're doing, this should probably be false (the default value).", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "List of inclusion patterns (using Ant-style path expressions) to refine the contents of the project-sources archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceArtifactClassifier (Default: project-sources)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceArtifactType (Default: zip)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "tarLongFileMode (Default: gnu)", 2);
                this.append(sb, "Handling mode for long file paths.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "relocate".equals(this.goal)) {
            this.append(sb, "project-sources:relocate", 0);
            this.append(sb, "Move a set of files (usually unpacked project sources) from one place to another, optionally preserving the original location (copy-only).", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "copyOnly (Default: false)", 2);
                this.append(sb, "If true, copy the source directory structure, don't move it. This means the original location will not be deleted when the operation completes. Default value is false.", 3);
                this.append(sb, "", 0);
                this.append(sb, "from", 2);
                this.append(sb, "The originating location of the sources to be moved.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipPomProjects (Default: true)", 2);
                this.append(sb, "Flag determining whether this mojo will attempt to execute when the current project's packaging is 'pom'. Default behavior is to skip 'pom' projects.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceArtifactClassifier (Default: project-sources)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceArtifactType (Default: zip)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "to", 2);
                this.append(sb, "The target location where project sources should be moved to.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "resolve-project-sources".equals(this.goal)) {
            this.append(sb, "project-sources:resolve-project-sources", 0);
            this.append(sb, "(no description available)", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "optimizations (Default: true)", 2);
                this.append(sb, "If set to false, don't attempt to optimize the unpack step based on the pre-existence of the unpack directory and its contents. By default, optimizations are enabled.", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectDirIsSourceLocation (Default: false)", 2);
                this.append(sb, "Flag denoting whether the current project build directory can be used as a valid sourceLocation. Projects will * either have a source archive from elsewhwere (third-party build), or it will have an initial sourceLocation of * the current project directory (internal projects).", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipResolution (Default: false)", 2);
                this.append(sb, "If this flag is set, the mojo will not attempt project-source-artifact resolution, but will instead simply verify * and then set the project-source location (in the ProjectSourceContext).", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipUnpack (Default: false)", 2);
                this.append(sb, "If this flag is set, the mojo will not unpack the archive, just place it in the project ${sourceUnpackDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceArtifactClassifier (Default: project-sources)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceArtifactType (Default: zip)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceLocation (Default: ${project.basedir})", 2);
                this.append(sb, "This is the location of the project source code (in archive form, for third-party projects... or, in directory * form, for internal projects) on the local filesystem, for new builds that don't have project-sources stored in * the repository already.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceUnpackDirectory (Default: ${project.build.directory}/${project.artifactId}-${project.version})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceUnpackSubpath", 2);
                this.append(sb, "This is the subpath within the unpacked patch-archive, where patches should reside.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = this.toLines(description, indent).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private List toLines(String text, int indent) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            this.toLines(lines, ind + plainLines[i]);
        }
        return lines;
    }

    private void toLines(List lines, String line) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= this.lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * this.indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", this.indentSize - buf.length() % this.indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

