/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.patch;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.patch.AbstractPatchMojo;
import org.codehaus.mojo.tools.project.extras.DerivedArtifact;

public class PurgePatchArtifactFromLocalRepoMojo
extends AbstractPatchMojo {
    private ArtifactRepository localRepository;
    private String patchArtifactClassifier;
    private String patchArtifactType;
    private Artifact projectArtifact;

    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        DefaultArtifactHandler handler = new DefaultArtifactHandler(this.patchArtifactType);
        DerivedArtifact patchArtifact = new DerivedArtifact(this.projectArtifact, this.patchArtifactClassifier, this.patchArtifactType, (ArtifactHandler)handler);
        if (patchArtifact != null) {
            String relativePath = this.localRepository.pathOf((Artifact)patchArtifact);
            File patchArtifactLocalRepoFile = new File(this.localRepository.getBasedir(), relativePath);
            this.getLog().debug((CharSequence)("trying to purge: " + patchArtifactLocalRepoFile.getAbsolutePath()));
            if (patchArtifactLocalRepoFile.exists()) {
                this.getLog().debug((CharSequence)("Purging: " + patchArtifact + " from local repository at: " + this.localRepository.getBasedir()));
                patchArtifactLocalRepoFile.delete();
            }
        }
    }
}

