/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.multibuild.optimizer;

import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.tools.context.BuildAdvisor;
import org.codehaus.mojo.tools.project.extras.ScanningUtils;
import org.codehaus.plexus.util.StringUtils;

public class SkipIfBuiltOptimizerMojo
extends AbstractMojo {
    private static final Set DEFAULT_INCLUDES;
    private boolean forceBuild;
    private List compileSourceRoots;
    private File checkDirectory;
    private Set includes;
    private Set excludes;
    private Artifact projectArtifact;
    private MavenProject project;
    private String type;
    private boolean checkArtifact;
    private String archiveUrl;
    private List remoteRepositories;
    private ArtifactRepository localRepository;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver resolver;
    private BuildAdvisor buildAdvisor;
    private MavenSession session;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.forceBuild) {
            this.getLog().debug((CharSequence)"The current build has been forced. Optimizations are disabled.");
            return;
        }
        File buildResult = this.projectArtifact.getFile();
        if (buildResult == null || !buildResult.exists()) {
            this.getLog().debug((CharSequence)("Project's package file: " + buildResult + " does not exist. Build should continue."));
            return;
        }
        Long lastMod = null;
        if (this.checkArtifact) {
            try {
                lastMod = this.checkArtifact();
            }
            catch (ArtifactResolutionException e) {
                this.getLog().debug((CharSequence)("Error checking for package staleness: " + e.getMessage() + ". Build will proceed."), (Throwable)e);
                lastMod = null;
            }
            catch (ArtifactNotFoundException e) {
                this.getLog().debug((CharSequence)("Error checking for package staleness: " + e.getMessage() + ". Build will proceed."), (Throwable)e);
                lastMod = null;
            }
        } else {
            lastMod = this.checkFiles();
        }
        if (lastMod == null || lastMod > buildResult.lastModified()) {
            StringBuffer message = new StringBuffer();
            message.append("Project's package file: ").append(buildResult).append(" is stale. Build should continue.");
            if (lastMod != null) {
                message.append("\nLatest source modification: ").append(new Date(lastMod));
            }
            message.append("\nPackage file modification: ").append(new Date(buildResult.lastModified()));
        } else {
            this.getLog().info((CharSequence)"Project sources have not changed since last build. Build should be skipped.");
            this.buildAdvisor.skipProjectBuild(this.session);
        }
    }

    private Long checkArtifact() throws ArtifactResolutionException, ArtifactNotFoundException {
        Long lastMod = null;
        File sourceArchive = null;
        if (StringUtils.isNotEmpty((String)this.archiveUrl)) {
            sourceArchive = new File(this.archiveUrl);
            if (sourceArchive.exists()) {
                this.getLog().info((CharSequence)("Using source archive from local directory: " + sourceArchive));
                sourceArchive = new File(this.archiveUrl);
            } else {
                this.getLog().info((CharSequence)"Using source archive from repository.");
                Artifact sourceArtifact = this.artifactFactory.createArtifactWithClassifier(this.projectArtifact.getGroupId(), this.projectArtifact.getArtifactId(), this.projectArtifact.getVersion(), this.type, "sources");
                this.resolver.resolve(sourceArtifact, this.remoteRepositories, this.localRepository);
                sourceArchive = sourceArtifact.getFile();
            }
        }
        if (sourceArchive != null && sourceArchive.exists()) {
            lastMod = new Long(sourceArchive.lastModified());
        }
        return lastMod;
    }

    private Long checkFiles() {
        List<String> toCheck;
        Long lastMod = null;
        if (this.checkDirectory != null) {
            this.getLog().info((CharSequence)("Checking alternate source location: " + this.checkDirectory + " for staleness."));
            toCheck = Collections.singletonList(this.checkDirectory.getAbsolutePath());
        } else {
            this.getLog().info((CharSequence)("Checking compile source roots: " + this.compileSourceRoots + " for staleness."));
            toCheck = this.compileSourceRoots;
        }
        if (toCheck != null && !toCheck.isEmpty()) {
            for (String sourcePath : toCheck) {
                File sourceLocation;
                if (sourcePath == null || !(sourceLocation = new File(sourcePath)).exists()) continue;
                long lm = 0L;
                if (sourceLocation.isDirectory()) {
                    Set includePatterns = this.includes == null || this.includes.isEmpty() ? DEFAULT_INCLUDES : this.includes;
                    lm = ScanningUtils.getLatestLastMod((File)sourceLocation, (Set)includePatterns, (Set)this.excludes);
                } else {
                    lm = sourceLocation.lastModified();
                }
                if (lastMod != null && lm <= lastMod) continue;
                lastMod = new Long(lm);
            }
        }
        return lastMod;
    }

    static {
        HashSet<String> defaultIncludes = new HashSet<String>();
        defaultIncludes.add("**/*");
        DEFAULT_INCLUDES = defaultIncludes;
    }
}

