/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.utils;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.maven.plugin.MojoExecutionException;

public class UrlRequester {
    public static final String CLASSPATH_PROTOCOL = "classpath";

    public static boolean isStringUrl(String data) {
        if (StringUtils.isBlank((CharSequence)data)) {
            return false;
        }
        if (data.startsWith("classpath:")) {
            return true;
        }
        try {
            new URL(data);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static String getFromUrl(String url) throws IOException {
        return UrlRequester.getFromUrl(url, "UTF-8");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getFromUrl(String url, String encoding) throws IOException {
        String protocol = StringUtils.substringBefore((String)url, (String)":").toLowerCase();
        Charset charset = Charset.forName(encoding);
        String result = null;
        if (CLASSPATH_PROTOCOL.equals(protocol)) {
            String resource;
            ClassLoader classLoader = UrlRequester.class.getClassLoader();
            URL resourceUrl = classLoader.getResource(resource = url.substring(CLASSPATH_PROTOCOL.length() + 1));
            if (resourceUrl == null) throw new IOException("The resource " + resource + " was not found in the maven plugin classpath");
            return IOUtils.toString((URL)resourceUrl, (Charset)charset);
        }
        if (!"http".equals(protocol)) {
            if (!"https".equals(protocol)) return IOUtils.toString((InputStream)new URL(url).openStream(), (Charset)charset);
        }
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            HttpGet get = new HttpGet(url);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);){
                int responseCode = response.getStatusLine().getStatusCode();
                if (responseCode < 200) throw new IOException("For the URL (" + url + ") the server responded with " + response.getStatusLine());
                if (responseCode >= 300) throw new IOException("For the URL (" + url + ") the server responded with " + response.getStatusLine());
                HttpEntity entity = response.getEntity();
                ContentType contentType = ContentType.get((HttpEntity)entity);
                if (contentType != null) {
                    charset = contentType.getCharset();
                }
                result = IOUtils.toString((InputStream)entity.getContent(), (Charset)charset);
                return result;
            }
        }
    }

    public static List<String> downloadList(String url) throws MojoExecutionException {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        try {
            String line;
            bufferedReader = new BufferedReader(new CharArrayReader(UrlRequester.getFromUrl(url).toCharArray()));
            while ((line = bufferedReader.readLine()) != null) {
                if (!StringUtils.isNotBlank((CharSequence)line) || StringUtils.startsWith((CharSequence)line, (CharSequence)"#") || list.contains(line)) continue;
                list.add(line);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not open connection to URL: " + url, (Exception)e);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
        }
        return list;
    }
}

