/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.download;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.license.download.LicenseSummaryReader;
import org.codehaus.mojo.license.download.ProjectLicense;
import org.codehaus.mojo.license.download.ProjectLicenseInfo;

public class LicenseMatchers {
    private static final Pattern MATCH_EMPTY_PATTERN = Pattern.compile("");
    private static final Pattern MATCH_ALL_PATTERN = Pattern.compile(".*");
    private final List<DependencyMatcher> matchers;

    public static Builder builder() {
        return new Builder();
    }

    public static LicenseMatchers load(File licenseMatchersFile) throws MojoExecutionException {
        ArrayList<DependencyMatcher> matchers = new ArrayList<DependencyMatcher>();
        try {
            if (licenseMatchersFile != null && licenseMatchersFile.exists()) {
                List<ProjectLicenseInfo> replacements = LicenseSummaryReader.parseLicenseSummary(licenseMatchersFile);
                for (ProjectLicenseInfo dependency : replacements) {
                    matchers.add(DependencyMatcher.of(dependency));
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not parse licensesReplacementsFile " + licenseMatchersFile, e);
        }
        return new LicenseMatchers(matchers);
    }

    private static boolean match(Pattern pattern, String string) {
        return string == null ? pattern.matcher("").matches() : pattern.matcher(string).matches();
    }

    private static Pattern pattern(String string, boolean isPre118Match) {
        return string == null || string.isEmpty() ? MATCH_EMPTY_PATTERN : (isPre118Match ? Pattern.compile(Pattern.quote(string)) : Pattern.compile(string, 2));
    }

    private LicenseMatchers(List<DependencyMatcher> matchers) {
        this.matchers = matchers;
    }

    public void replaceMatches(ProjectLicenseInfo dependency) {
        for (DependencyMatcher matcher : this.matchers) {
            if (!matcher.matches(dependency)) continue;
            if (!matcher.isApproved()) {
                dependency.setLicenses(matcher.cloneLicenses());
            }
            dependency.setApproved(true);
            dependency.getDownloaderMessages().clear();
        }
    }

    static class LicenseMatcher {
        private final Pattern comments;
        private final Pattern distribution;
        private final Pattern name;
        private final Pattern url;

        LicenseMatcher(Pattern name, Pattern url, Pattern distribution, Pattern comments) {
            this.name = name;
            this.url = url;
            this.distribution = distribution;
            this.comments = comments;
        }

        LicenseMatcher(String name, String url, String distribution, String comments) {
            this.name = LicenseMatchers.pattern(name, false);
            this.url = LicenseMatchers.pattern(url, false);
            this.distribution = LicenseMatchers.pattern(distribution, false);
            this.comments = LicenseMatchers.pattern(comments, false);
        }

        public boolean matches(ProjectLicense license) {
            return LicenseMatchers.match(this.name, license.getName()) && LicenseMatchers.match(this.url, license.getUrl()) && LicenseMatchers.match(this.distribution, license.getDistribution()) && LicenseMatchers.match(this.comments, license.getComments());
        }
    }

    static class LicenseListMatcher {
        private final List<LicenseMatcher> licenseMatchers;
        private static final LicenseListMatcher MATCHES_ALL_LICENSE_LIST_MATCHER = new LicenseListMatcher(null){

            @Override
            public boolean matches(List<ProjectLicense> licenses) {
                return true;
            }
        };

        public LicenseListMatcher(List<LicenseMatcher> licenseMatchers) {
            this.licenseMatchers = licenseMatchers;
        }

        public boolean matches(List<ProjectLicense> licenses) {
            int licsSize;
            int n = licsSize = licenses == null ? 0 : licenses.size();
            if (this.licenseMatchers.size() != licsSize) {
                return false;
            }
            Iterator<LicenseMatcher> matchersIt = this.licenseMatchers.iterator();
            Iterator<ProjectLicense> licsIt = licenses.iterator();
            while (matchersIt.hasNext()) {
                if (matchersIt.next().matches(licsIt.next())) continue;
                return false;
            }
            return true;
        }

        public static LicenseListMatcher of(ProjectLicenseInfo dependency) {
            List<LicenseMatcher> licenseMatchers;
            if (!dependency.hasMatchLicenses()) {
                return MATCHES_ALL_LICENSE_LIST_MATCHER;
            }
            List<ProjectLicense> rawMatchers = dependency.getMatchLicenses();
            if (rawMatchers == null || rawMatchers.isEmpty()) {
                licenseMatchers = Collections.emptyList();
            } else {
                licenseMatchers = new ArrayList();
                for (ProjectLicense lic : rawMatchers) {
                    licenseMatchers.add(new LicenseMatcher(lic.getName(), lic.getUrl(), lic.getDistribution(), lic.getComments()));
                }
            }
            return new LicenseListMatcher(licenseMatchers);
        }
    }

    static class DependencyMatcher {
        private final Pattern artifactId;
        private final Pattern groupId;
        private final LicenseListMatcher licenseListMatcher;
        private final boolean approved;
        private final List<ProjectLicense> licenses;
        private final Pattern version;

        public static DependencyMatcher of(ProjectLicenseInfo dependency) {
            String version = dependency.getVersion();
            boolean isPre118Match = !dependency.hasMatchLicenses();
            return new DependencyMatcher(LicenseMatchers.pattern(dependency.getGroupId(), isPre118Match), LicenseMatchers.pattern(dependency.getArtifactId(), isPre118Match), isPre118Match || version == null || version.isEmpty() ? MATCH_ALL_PATTERN : Pattern.compile(version, 2), LicenseListMatcher.of(dependency), dependency.cloneLicenses(), dependency.isApproved());
        }

        DependencyMatcher(Pattern groupId, Pattern artifactId, Pattern version, LicenseListMatcher licenseListMatcher, List<ProjectLicense> licenses, boolean approved) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.licenseListMatcher = licenseListMatcher;
            this.licenses = licenses;
            this.approved = approved;
        }

        public List<ProjectLicense> getLicenseMatchers() {
            return null;
        }

        public List<ProjectLicense> cloneLicenses() {
            try {
                ArrayList<ProjectLicense> result = new ArrayList<ProjectLicense>(this.licenses != null ? this.licenses.size() : 0);
                if (this.licenses != null) {
                    for (ProjectLicense license : this.licenses) {
                        result.add(license.clone());
                    }
                }
                return result;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean matches(ProjectLicenseInfo dependency) {
            return LicenseMatchers.match(this.groupId, dependency.getGroupId()) && LicenseMatchers.match(this.artifactId, dependency.getArtifactId()) && LicenseMatchers.match(this.version, dependency.getVersion()) && this.licenseListMatcher.matches(dependency.getLicenses());
        }

        public boolean isApproved() {
            return this.approved;
        }
    }

    public static class Builder {
        private List<DependencyMatcher> matchers = new ArrayList<DependencyMatcher>();

        public Builder matcher(DependencyMatcher matcher) {
            this.matchers.add(matcher);
            return this;
        }

        public LicenseMatchers build() {
            List<DependencyMatcher> ms = this.matchers;
            this.matchers = null;
            return new LicenseMatchers(ms);
        }
    }
}

