/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.license.utils.UrlRequester;

public final class LicenseMojoUtils {
    static final String NO_URL = "file:///inexistent";
    static final String DEFAULT_OVERRIDE_THIRD_PARTY = "src/license/override-THIRD-PARTY.properties";

    private LicenseMojoUtils() {
    }

    public static boolean isValid(String url) {
        return url != null && !NO_URL.equals(url);
    }

    static String prepareThirdPartyOverrideUrl(String resolvedUrl, File deprecatedFile, String url, File basedir, Log log) {
        if (deprecatedFile != null) {
            log.warn((CharSequence)"'overrideFile' mojo parameter is deprecated. Use 'overrideUrl' instead.");
        }
        return LicenseMojoUtils.prepareUrl(resolvedUrl, deprecatedFile, url, basedir, DEFAULT_OVERRIDE_THIRD_PARTY);
    }

    private static String prepareUrl(String resolvedUrl, File deprecatedFile, String url, File basedir, String defaultFilePath) {
        if (resolvedUrl != null && !NO_URL.equals(resolvedUrl)) {
            return resolvedUrl;
        }
        if (deprecatedFile != null && url != null && !url.isEmpty()) {
            throw new IllegalArgumentException("You can't use both overrideFile and overrideUrl");
        }
        if (deprecatedFile != null && deprecatedFile.exists()) {
            return deprecatedFile.toURI().toString();
        }
        Path basedirPath = basedir.toPath();
        if (url != null && UrlRequester.isStringUrl(url)) {
            return basedirPath.toUri().toString();
        }
        Path defaultPath = basedirPath.resolve(defaultFilePath);
        if (Files.exists(defaultPath, new LinkOption[0])) {
            return defaultPath.toUri().toString();
        }
        return NO_URL;
    }
}

