/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.header.transformer;

import org.codehaus.mojo.license.header.transformer.AbstractFileHeaderTransformer;
import org.codehaus.mojo.license.header.transformer.FileHeaderTransformer;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=FileHeaderTransformer.class, hint="html")
public class HtmlFileHeaderTransformer
extends AbstractFileHeaderTransformer {
    public HtmlFileHeaderTransformer() {
        super("xml", "header transformer with html comment style", "<!--", "  -->", "  ");
    }

    public String[] getDefaultAcceptedExtensions() {
        return new String[]{"xhtml", "html", "htm"};
    }

    public String addHeader(String header, String content) {
        String result;
        int endProlog;
        String prolog = null;
        int startProlog = content.indexOf("<!DOCTYPE");
        if (startProlog > -1 && (endProlog = content.indexOf(">", startProlog)) > -1) {
            prolog = content.substring(0, endProlog + 1);
        }
        if (prolog == null) {
            result = super.addHeader(header, content);
        } else {
            content = content.substring(prolog.length());
            result = super.addHeader(prolog + '\n' + header, content);
        }
        return result;
    }
}

