/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javancss;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY)
@Execute(goal="report")
public class NcssViolationCheckMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.sourceDirectory}", readonly=true, required=true)
    private File sourceDirectory;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private File xmlOutputDirectory;
    @Parameter(defaultValue="true")
    private boolean failOnViolation;
    @Parameter(defaultValue="javancss-raw-report.xml")
    private String tempFileName;
    @Parameter(defaultValue="10")
    private int ccnLimit;
    @Parameter(defaultValue="100")
    private int ncssLimit;
    @Parameter(property="ncss.skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.sourceDirectory == null || !this.sourceDirectory.exists()) {
            return;
        }
        HashSet<String> ccnViolation = new HashSet<String>();
        HashSet<String> ncssViolation = new HashSet<String>();
        List methodList = this.loadDocument().selectNodes("//javancss/functions/function");
        for (Node node : methodList) {
            int ncss;
            int ccn = new Integer(node.valueOf("ccn"));
            if (ccn > this.ccnLimit) {
                ccnViolation.add(node.valueOf("name"));
            }
            if ((ncss = new Integer(node.valueOf("ncss")).intValue()) <= this.ncssLimit) continue;
            ncssViolation.add(node.valueOf("name"));
        }
        this.reportViolation("ccn", ccnViolation, this.ccnLimit);
        this.reportViolation("ncss", ncssViolation, this.ncssLimit);
    }

    private Document loadDocument() throws MojoFailureException {
        File ncssXmlFile = new File(this.xmlOutputDirectory, this.tempFileName);
        try {
            return new SAXReader().read(ncssXmlFile);
        }
        catch (DocumentException de) {
            throw new MojoFailureException("Can't read javancss xml output file : " + ncssXmlFile);
        }
    }

    private void reportViolation(String statName, Set<String> violationSet, int limit) throws MojoFailureException {
        this.getLog().debug((CharSequence)(statName + " Violation = " + violationSet.size()));
        if (violationSet.size() > 0) {
            String violationString = "Your code has " + violationSet.size() + " method(s) with a " + statName + " greater than " + limit;
            this.getLog().warn((CharSequence)violationString);
            for (String violation : violationSet) {
                this.getLog().warn((CharSequence)("    " + violation));
            }
            if (this.failOnViolation) {
                throw new MojoFailureException(violationString);
            }
        }
    }
}

