/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javancss;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.mojo.javancss.ModuleReport;
import org.codehaus.mojo.javancss.NcssAggregateReportGenerator;
import org.codehaus.mojo.javancss.NcssExecuter;
import org.codehaus.mojo.javancss.NcssReportGenerator;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public class NcssReportMojo
extends AbstractMavenReport {
    private static final String OUTPUT_NAME = "javancss";
    private File outputDirectory;
    private File xmlOutputDirectory;
    private File sourceDirectory;
    private String sourceEncoding;
    private int lineThreshold;
    private String tempFileName;
    private MavenProject project;
    private SiteRenderer siteRenderer;
    private List reactorProjects;
    private boolean linkXRef;
    private File xrefLocation;
    private String[] includes;
    private String[] excludes;

    protected String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public void executeReport(Locale locale) throws MavenReportException {
        if (!this.canGenerateReport()) {
            return;
        }
        if (this.canGenerateSingleReport()) {
            this.generateSingleReport(locale);
        }
        if (this.canGenerateAggregateReport()) {
            this.generateAggregateReport(locale);
        }
    }

    private void generateAggregateReport(Locale locale) throws MavenReportException {
        String basedir = this.project.getBasedir().toString();
        String output = this.xmlOutputDirectory.toString();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("basedir: " + basedir));
            this.getLog().debug((CharSequence)("output: " + output));
        }
        String relative = null;
        if (!output.startsWith(basedir)) {
            this.getLog().error((CharSequence)"Unable to aggregate report because I can't determine the relative location of the XML report");
            return;
        }
        relative = output.substring(basedir.length() + 1);
        this.getLog().debug((CharSequence)("relative: " + relative));
        ArrayList<ModuleReport> reports = new ArrayList<ModuleReport>();
        Iterator it = this.reactorProjects.iterator();
        while (it.hasNext()) {
            MavenProject child = (MavenProject)it.next();
            File xmlReport = new File(child.getBasedir() + File.separator + relative, this.tempFileName);
            if (xmlReport.exists()) {
                reports.add(new ModuleReport(child, this.loadDocument(xmlReport)));
                continue;
            }
            this.getLog().debug((CharSequence)("xml file not found: " + xmlReport));
        }
        this.getLog().debug((CharSequence)("Aggregating " + reports.size() + " JavaNCSS reports"));
        NcssAggregateReportGenerator reportGenerator = new NcssAggregateReportGenerator(this.getSink(), NcssReportMojo.getBundle(locale), this.getLog());
        reportGenerator.doReport(locale, reports, this.lineThreshold);
    }

    private boolean isIncludeExcludeUsed() {
        return this.excludes != null || this.includes != null;
    }

    private void generateSingleReport(Locale locale) throws MavenReportException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Calling NCSSExecuter with src    : " + this.sourceDirectory));
            this.getLog().debug((CharSequence)("Calling NCSSExecuter with output : " + this.buildOutputFileName()));
            this.getLog().debug((CharSequence)("Calling NCSSExecuter with includes : " + this.includes));
            this.getLog().debug((CharSequence)("Calling NCSSExecuter with excludes : " + this.excludes));
            this.getLog().debug((CharSequence)("Calling NCSSExecuter with encoding : " + this.getSourceEncoding()));
        }
        NcssExecuter ncssExecuter = this.isIncludeExcludeUsed() ? new NcssExecuter(this.scanForSources(), this.buildOutputFileName()) : new NcssExecuter(this.sourceDirectory, this.buildOutputFileName());
        ncssExecuter.setEncoding(this.getSourceEncoding());
        ncssExecuter.execute();
        if (!this.isTempReportGenerated()) {
            throw new MavenReportException("Can't process temp ncss xml file.");
        }
        NcssReportGenerator reportGenerator = new NcssReportGenerator(this.getSink(), NcssReportMojo.getBundle(locale), this.getLog(), this.constructXRefLocation());
        reportGenerator.doReport(this.loadDocument(), this.lineThreshold);
    }

    private Document loadDocument(File file) throws MavenReportException {
        try {
            SAXReader saxReader = new SAXReader();
            return saxReader.read((Reader)ReaderFactory.newXmlReader((File)file));
        }
        catch (DocumentException de) {
            throw new MavenReportException(de.getMessage(), (Exception)((Object)de));
        }
        catch (IOException ioe) {
            throw new MavenReportException(ioe.getMessage(), (Exception)ioe);
        }
    }

    private Document loadDocument() throws MavenReportException {
        return this.loadDocument(new File(this.buildOutputFileName()));
    }

    private boolean isTempReportGenerated() {
        return new File(this.buildOutputFileName()).exists();
    }

    public boolean canGenerateReport() {
        return this.canGenerateSingleReport() || this.canGenerateAggregateReport();
    }

    private boolean canGenerateAggregateReport() {
        if (this.project.getModules().size() == 0) {
            return false;
        }
        if (this.sourceDirectory != null && this.sourceDirectory.exists()) {
            String[] sources = this.scanForSources();
            return sources == null || sources.length <= 0;
        }
        return true;
    }

    private boolean canGenerateSingleReport() {
        if (this.sourceDirectory == null || !this.sourceDirectory.exists()) {
            return false;
        }
        String[] sources = this.scanForSources();
        return sources != null && sources.length > 0;
    }

    private String[] scanForSources() {
        String[] defaultIncludes = new String[]{"**\\*.java"};
        DirectoryScanner ds = new DirectoryScanner();
        if (this.includes == null) {
            ds.setIncludes(defaultIncludes);
        } else {
            ds.setIncludes(this.includes);
        }
        if (this.excludes != null) {
            ds.setExcludes(this.excludes);
        }
        ds.setBasedir(this.sourceDirectory);
        this.getLog().debug((CharSequence)("Scanning base directory " + this.sourceDirectory));
        ds.scan();
        int maxFiles = ds.getIncludedFiles().length;
        String[] result = new String[maxFiles];
        for (int i = 0; i < maxFiles; ++i) {
            result[i] = this.sourceDirectory + File.separator + ds.getIncludedFiles()[i];
        }
        return result;
    }

    String buildOutputFileName() {
        return this.getXmlOutputDirectory() + File.separator + this.tempFileName;
    }

    public String getName(Locale locale) {
        return NcssReportMojo.getBundle(locale).getString("report.javancss.name");
    }

    public String getDescription(Locale locale) {
        return NcssReportMojo.getBundle(locale).getString("report.javancss.description");
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected String getXmlOutputDirectory() {
        return this.xmlOutputDirectory.getAbsolutePath();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public String getOutputName() {
        return OUTPUT_NAME;
    }

    protected File getSourceDirectory() {
        return this.sourceDirectory;
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("javancss-report", locale, NcssReportMojo.class.getClassLoader());
    }

    protected String constructXRefLocation() {
        String location = null;
        if (this.linkXRef) {
            String relativePath = PathTool.getRelativePath((String)this.outputDirectory.getAbsolutePath(), (String)this.xrefLocation.getAbsolutePath());
            if (StringUtils.isEmpty((String)relativePath)) {
                relativePath = ".";
            }
            relativePath = relativePath + "/" + this.xrefLocation.getName();
            if (this.xrefLocation.exists()) {
                location = relativePath;
            } else {
                Iterator reports = this.project.getReportPlugins().iterator();
                while (reports.hasNext()) {
                    ReportPlugin plugin = (ReportPlugin)reports.next();
                    String artifactId = plugin.getArtifactId();
                    if (!"maven-jxr-plugin".equals(artifactId) && !"jxr-maven-plugin".equals(artifactId)) continue;
                    location = relativePath;
                }
            }
            if (location == null) {
                this.getLog().warn((CharSequence)"Unable to locate Source XRef to link to - DISABLED");
            }
        }
        return location;
    }
}

