/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.extraenforcer.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.enforcer.rule.api.AbstractEnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.model.Contributor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

abstract class AbstractRequireRoles<T extends Contributor>
extends AbstractEnforcerRule {
    private String requiredRoles = "";
    private String validRoles = "*";
    private final MavenProject project;

    AbstractRequireRoles(MavenProject project) {
        this.project = project;
    }

    public void execute() throws EnforcerRuleException {
        Set<String> requiredRolesSet = Collections.unmodifiableSet(this.getRolesFromString(this.requiredRoles));
        Set<String> rolesFromProject = Collections.unmodifiableSet(this.getRolesFromProject(this.project));
        this.checkRequiredRoles(requiredRolesSet, rolesFromProject);
        this.checkValidRoles(requiredRolesSet, rolesFromProject);
    }

    private void checkRequiredRoles(Set<String> requiredRolesSet, Set<String> rolesFromProject) throws EnforcerRuleException {
        LinkedHashSet<String> copyOfRequiredRolesSet = new LinkedHashSet<String>(requiredRolesSet);
        copyOfRequiredRolesSet.removeAll(rolesFromProject);
        if (copyOfRequiredRolesSet.size() > 0) {
            String message = String.format("Found no %s representing role(s) '%s'", this.getRoleName(), copyOfRequiredRolesSet);
            throw new EnforcerRuleException(message);
        }
    }

    private void checkValidRoles(Set<String> requiredRolesSet, Set<String> rolesFromProject) throws EnforcerRuleException {
        LinkedHashSet<String> copyOfRolesFromProject = new LinkedHashSet<String>(rolesFromProject);
        Set<String> allowedRoles = this.getRolesFromString(this.validRoles);
        if (!allowedRoles.contains("*")) {
            allowedRoles.addAll(requiredRolesSet);
            copyOfRolesFromProject.removeAll(allowedRoles);
            if (copyOfRolesFromProject.size() > 0) {
                String message = String.format("Found invalid %s role(s) '%s'", this.getRoleName(), copyOfRolesFromProject);
                throw new EnforcerRuleException(message);
            }
        }
    }

    final Set<String> getRolesFromProject(MavenProject mavenProject) {
        HashSet<String> result = new HashSet<String>();
        for (Contributor roleFromPom : this.getRoles(mavenProject)) {
            List roles = roleFromPom.getRoles();
            result.addAll(roles);
        }
        return result;
    }

    protected abstract String getRoleName();

    protected abstract List<T> getRoles(MavenProject var1);

    Set<String> getRolesFromString(String csRoles) {
        return AbstractRequireRoles.splitCsvToSet(csRoles);
    }

    static Set<String> splitCsvToSet(String csv) {
        String[] splitValues = StringUtils.split((String)csv, (String)",");
        HashSet<String> result = new HashSet<String>();
        for (String value : splitValues) {
            result.add(value.trim());
        }
        return result;
    }

    void setRequiredRoles(String requiredRoles) {
        this.requiredRoles = requiredRoles;
    }

    void setValidRoles(String validRoles) {
        this.validRoles = validRoles;
    }
}

