/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.extraenforcer.dependencies;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.shared.artifact.filter.StrictPatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.StrictPatternIncludesArtifactFilter;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.codehaus.mojo.extraenforcer.dependencies.AbstractResolveDependencies;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.aether.RepositorySystem;

@Named(value="enforceBytecodeVersion")
public class EnforceBytecodeVersion
extends AbstractResolveDependencies {
    private static final Map<String, Integer> JDK_TO_MAJOR_VERSION_NUMBER_MAPPING = new LinkedHashMap<String, Integer>();
    private static final String[] DEFAULT_CLASSES_IGNORE_BEFORE_JDK_9 = new String[]{"module-info"};
    private static final Pattern MULTIRELEASE = Pattern.compile("META-INF/versions/(\\d+)/.*");
    private String message;
    private String maxJdkVersion;
    int maxJavaMajorVersionNumber = -1;
    int maxJavaMinorVersionNumber = 0;
    private boolean searchTransitive = true;
    private List<String> includes;
    private List<String> excludes;
    private String[] ignoreClasses;
    private boolean strict = false;
    private String[] ignoredScopes;
    private boolean ignoreOptionals = false;
    private List<AbstractResolveDependencies.IgnorableDependency> ignorableDependencies = new ArrayList<AbstractResolveDependencies.IgnorableDependency>();

    @Inject
    protected EnforceBytecodeVersion(MavenSession session, RepositorySystem repositorySystem, DependencyGraphBuilder graphBuilder) {
        super(session, repositorySystem, graphBuilder);
    }

    static String renderVersion(int major, int minor) {
        if (minor == 0) {
            for (Map.Entry<String, Integer> entry : JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.entrySet()) {
                if (major != entry.getValue()) continue;
                return "JDK " + entry.getKey();
            }
        }
        return major + "." + minor;
    }

    @Override
    protected void handleArtifacts(Set<Artifact> artifacts) throws EnforcerRuleException {
        this.computeParameters();
        Set<Artifact> foundExcludes = this.checkDependencies(this.filterArtifacts(artifacts));
        if (foundExcludes != null && !foundExcludes.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            if (this.message != null) {
                buf.append(this.message).append("\n");
            }
            for (Artifact artifact : foundExcludes) {
                buf.append(this.getErrorMessage(artifact));
            }
            this.message = buf + "Use 'mvn dependency:tree' to locate the source of the banned dependencies.";
            throw new EnforcerRuleException(this.message);
        }
    }

    @Override
    protected boolean isSearchTransitive() {
        return this.searchTransitive;
    }

    protected CharSequence getErrorMessage(Artifact artifact) {
        return "Found Banned Dependency: " + artifact.getId() + "\n";
    }

    private void computeParameters() throws EnforcerRuleException {
        if (this.maxJdkVersion != null && this.maxJavaMajorVersionNumber != -1) {
            throw new IllegalArgumentException("Only maxJdkVersion or maxJavaMajorVersionNumber configuration parameters should be set. Not both.");
        }
        if (this.maxJdkVersion == null && this.maxJavaMajorVersionNumber == -1) {
            throw new IllegalArgumentException("Exactly one of maxJdkVersion or maxJavaMajorVersionNumber options should be set.");
        }
        if (this.maxJdkVersion != null) {
            Integer needle = JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.get(this.maxJdkVersion);
            if (needle == null) {
                throw new IllegalArgumentException("Unknown JDK version given. Should be something like \"1.7\", \"8\", \"11\", \"12\", \"13\", \"14\", \"15\", \"16\", \"17\", \"18\", \"19\", \"20\"");
            }
            this.maxJavaMajorVersionNumber = needle;
            if (!this.strict && needle < 53) {
                AbstractResolveDependencies.IgnorableDependency ignoreModuleInfoDependency = new AbstractResolveDependencies.IgnorableDependency();
                ignoreModuleInfoDependency.applyIgnoreClasses(DEFAULT_CLASSES_IGNORE_BEFORE_JDK_9, false);
                this.ignorableDependencies.add(ignoreModuleInfoDependency);
            }
        }
        if (this.maxJavaMajorVersionNumber == -1) {
            throw new EnforcerRuleException("maxJavaMajorVersionNumber must be set in the plugin configuration");
        }
        if (this.ignoreClasses != null) {
            AbstractResolveDependencies.IgnorableDependency ignorableDependency = new AbstractResolveDependencies.IgnorableDependency();
            ignorableDependency.applyIgnoreClasses(this.ignoreClasses, false);
            this.ignorableDependencies.add(ignorableDependency);
        }
    }

    protected Set<Artifact> checkDependencies(Set<Artifact> dependencies) throws EnforcerRuleException {
        long beforeCheck = System.currentTimeMillis();
        LinkedHashSet<Artifact> problematic = new LinkedHashSet<Artifact>();
        for (Artifact artifact : dependencies) {
            this.getLog().debug((CharSequence)("Analyzing artifact " + artifact));
            String problem = this.isBadArtifact(artifact);
            if (problem == null) continue;
            this.getLog().info((CharSequence)problem);
            problematic.add(artifact);
        }
        this.getLog().debug((CharSequence)("Bytecode version analysis took " + (System.currentTimeMillis() - beforeCheck) + " ms"));
        return problematic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String isBadArtifact(Artifact a) throws EnforcerRuleException {
        File f = a.getFile();
        this.getLog().debug((CharSequence)("isBadArtifact() a:" + a + " Artifact getFile():" + a.getFile()));
        if (f == null) {
            return null;
        }
        if (!f.getName().endsWith(".jar")) {
            return null;
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(f);
            this.getLog().debug((CharSequence)(f.getName() + " => " + f.getPath()));
            byte[] magicAndClassFileVersion = new byte[8];
            Enumeration<JarEntry> e = jarFile.entries();
            block10: while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                for (AbstractResolveDependencies.IgnorableDependency i : this.ignorableDependencies) {
                    if (!i.matches(entry.getName())) continue;
                    continue block10;
                }
                InputStream is = null;
                try {
                    int read;
                    is = jarFile.getInputStream(entry);
                    for (int total = magicAndClassFileVersion.length; total > 0; total -= read) {
                        read = is.read(magicAndClassFileVersion, magicAndClassFileVersion.length - total, total);
                        if (read != -1) continue;
                        throw new EOFException(f.toString());
                    }
                    is.close();
                    is = null;
                }
                finally {
                    IOUtil.close((InputStream)is);
                }
                int minor = (magicAndClassFileVersion[4] << 8) + magicAndClassFileVersion[5];
                int major = (magicAndClassFileVersion[6] << 8) + magicAndClassFileVersion[7];
                if (major <= this.maxJavaMajorVersionNumber && (major != this.maxJavaMajorVersionNumber || minor <= this.maxJavaMinorVersionNumber)) continue;
                Matcher matcher = MULTIRELEASE.matcher(entry.getName());
                if (!this.strict && matcher.matches()) {
                    Integer maxExpectedMajor = JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.get(matcher.group(1));
                    if (maxExpectedMajor == null) {
                        this.getLog().warn((CharSequence)("Unknown bytecodeVersion for " + a + " : " + entry.getName() + ": got " + maxExpectedMajor + " class-file-version"));
                        continue;
                    }
                    if (major <= maxExpectedMajor) continue;
                    this.getLog().warn((CharSequence)("Invalid bytecodeVersion for " + a + " : " + entry.getName() + ": expected lower or equal to " + maxExpectedMajor + ", but was " + major));
                    continue;
                }
                String string = "Restricted to " + EnforceBytecodeVersion.renderVersion(this.maxJavaMajorVersionNumber, this.maxJavaMinorVersionNumber) + " yet " + a + " contains " + entry.getName() + " targeted to " + EnforceBytecodeVersion.renderVersion(major, minor);
                return string;
            }
        }
        catch (IOException e) {
            throw new EnforcerRuleException("IOException while reading " + f, (Exception)e);
        }
        catch (IllegalArgumentException e) {
            throw new EnforcerRuleException("Error while reading " + f, (Exception)e);
        }
        finally {
            this.closeQuietly(jarFile);
        }
        return null;
    }

    private void closeQuietly(JarFile jarFile) {
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (IOException ioe) {
                this.getLog().warn((CharSequence)("Exception catched while closing " + jarFile.getName() + ": " + ioe.getMessage()));
            }
        }
    }

    public void setMaxJavaMajorVersionNumber(int maxJavaMajorVersionNumber) {
        this.maxJavaMajorVersionNumber = maxJavaMajorVersionNumber;
    }

    public void setMaxJavaMinorVersionNumber(int maxJavaMinorVersionNumber) {
        this.maxJavaMinorVersionNumber = maxJavaMinorVersionNumber;
    }

    public void setSearchTransitive(boolean theSearchTransitive) {
        this.searchTransitive = theSearchTransitive;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    private Set<Artifact> filterArtifacts(Set<Artifact> dependencies) {
        if (this.includes == null && this.excludes == null && this.ignoredScopes == null && !this.ignoreOptionals) {
            return dependencies;
        }
        AndArtifactFilter filter = new AndArtifactFilter();
        if (this.includes != null) {
            filter.add((ArtifactFilter)new StrictPatternIncludesArtifactFilter(this.includes));
        }
        if (this.excludes != null) {
            filter.add((ArtifactFilter)new StrictPatternExcludesArtifactFilter(this.excludes));
        }
        HashSet<Artifact> result = new HashSet<Artifact>();
        for (Artifact artifact : dependencies) {
            if (this.ignoredScopes != null && Arrays.asList(this.ignoredScopes).contains(artifact.getScope()) || this.ignoreOptionals && artifact.isOptional() || !filter.include(artifact)) continue;
            result.add(artifact);
        }
        return result;
    }

    static {
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.1", 45);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.2", 46);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.3", 47);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.4", 48);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.5", 49);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.6", 50);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("6", 50);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.7", 51);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("7", 51);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("8", 52);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.8", 52);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("9", 53);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.9", 53);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("10", 54);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.10", 54);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("11", 55);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.11", 55);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("12", 56);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.12", 56);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("13", 57);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.13", 57);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("14", 58);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.14", 58);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("15", 59);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.15", 59);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("16", 60);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.16", 60);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("17", 61);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.17", 61);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("18", 62);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("19", 63);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("20", 64);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("21", 65);
    }
}

