/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.mojo.dashboard.report.plugin.AbstractDashBoardGenerator;
import org.codehaus.mojo.dashboard.report.plugin.beans.CheckstyleReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.CloverReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.CoberturaReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.CpdReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.DashBoardMavenProject;
import org.codehaus.mojo.dashboard.report.plugin.beans.FindBugsReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.IDashBoardReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.PmdReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.SurefireReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.TagListReportBean;

public class DashBoardMaven1ReportGenerator
extends AbstractDashBoardGenerator {
    private String dashboardAnchorLink = "/dashboard-report.html";
    private DashBoardMavenProject mavenProject;
    private Map map = new Hashtable();
    private boolean isDBAvailable = false;

    public DashBoardMaven1ReportGenerator(DashBoardMavenProject mavenProject, boolean isDBAvailable, Log log) {
        super(log);
        this.mavenProject = mavenProject;
        this.isDBAvailable = isDBAvailable;
        Set reports = mavenProject.getReports();
        Iterator iter = reports.iterator();
        while (iter.hasNext()) {
            IDashBoardReportBean report = (IDashBoardReportBean)iter.next();
            if (report == null) continue;
            this.map.put(report.getClass(), report);
        }
    }

    public void doGenerateReport(ResourceBundle bundle, Sink sink) {
        this.createTitle(bundle, sink);
        this.addDashboardCss(sink);
        this.sinkJavascriptCode(sink);
        sink.body();
        sink.anchor("top");
        sink.anchor_();
        this.createHeader(bundle, sink);
        this.createBodyReport(bundle, sink);
        sink.body_();
        sink.flush();
        sink.close();
    }

    public void createTitle(ResourceBundle bundle, Sink sink) {
        sink.head();
        sink.title();
        sink.text(bundle.getString("dashboard.multireport.name"));
        sink.title_();
        sink.head_();
    }

    public void createHeader(ResourceBundle bundle, Sink sink) {
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getString("dashboard.multireport.name") + " : " + this.mavenProject.getProjectName());
        sink.sectionTitle1_();
        sink.text("Date Generated: " + new SimpleDateFormat().format(new Date(System.currentTimeMillis())));
        sink.horizontalRule();
        if (this.isDBAvailable) {
            sink.sectionTitle3();
            sink.bold();
            sink.text("[");
            sink.link("dashboard-report-historic.html");
            sink.text("Go to Historic page");
            sink.link_();
            sink.text("]");
            sink.bold_();
            sink.sectionTitle3_();
            sink.horizontalRule();
        }
        sink.lineBreak();
        sink.section1_();
    }

    public void createBodyReport(ResourceBundle bundle, Sink sink) {
        System.out.println("DashBoardMultiReportGenerator createBodyByReport(...)");
        this.createAllSection(bundle, sink);
    }

    public void createAllSection(ResourceBundle bundle, Sink sink) {
        sink.table();
        this.writeSuperHeader(sink);
        this.writeHeader(bundle, sink, true);
        this.createAllLineByReport(bundle, sink, this.mavenProject, true, "");
        this.createTotalLine(bundle, sink, this.mavenProject);
        this.writeHeader(bundle, sink, false);
        this.writeSuperHeader(sink);
        sink.table_();
        sink.lineBreak();
    }

    public void createAllLineByReport(ResourceBundle bundle, Sink sink, DashBoardMavenProject mavenProject, boolean isRoot, String prefix) {
        if (mavenProject.getModules() != null && !mavenProject.getModules().isEmpty()) {
            Iterator iter = mavenProject.getModules().iterator();
            if (!isRoot) {
                prefix = this.writeMultiProjectRow(sink, mavenProject, prefix, this.dashboardAnchorLink);
            }
            while (iter.hasNext()) {
                DashBoardMavenProject subproject = (DashBoardMavenProject)iter.next();
                this.createAllLineByReport(bundle, sink, subproject, false, prefix);
            }
        } else {
            sink.tableRow();
            this.writeProjectCell(sink, mavenProject, prefix, this.dashboardAnchorLink);
            if (this.map.get(CoberturaReportBean.class) != null) {
                CoberturaReportBean coberReportBean = (CoberturaReportBean)mavenProject.getReportsByType(CoberturaReportBean.class);
                if (coberReportBean != null) {
                    this.sinkCellClass(sink, Integer.toString(coberReportBean.getNbClasses()), "cobertura");
                    this.sinkCellPercentGraphic(sink, coberReportBean.getLineCoverRate(), "cobertura");
                    this.sinkCellPercentGraphic(sink, coberReportBean.getBranchCoverRate(), "cobertura");
                    this.sinkHeaderBold(sink, "|");
                } else {
                    this.sinkCellClass(sink, "", "cobertura");
                    this.sinkCellClass(sink, "", "cobertura");
                    this.sinkCellClass(sink, "", "cobertura");
                    this.sinkHeaderBold(sink, "|");
                }
            }
            if (this.map.get(CloverReportBean.class) != null) {
                CloverReportBean cloverReportBean = (CloverReportBean)mavenProject.getReportsByType(CloverReportBean.class);
                if (cloverReportBean != null) {
                    this.sinkCellPercentGraphic(sink, cloverReportBean.getPercentCoveredConditionals(), "clover", "(" + cloverReportBean.getCoveredElements() + " / " + cloverReportBean.getElements() + ")");
                    this.sinkCellClass(sink, cloverReportBean.getConditionalsLabel(), "clover");
                    this.sinkCellClass(sink, cloverReportBean.getStatementsLabel(), "clover");
                    this.sinkCellClass(sink, cloverReportBean.getMethodsLabel(), "clover");
                    this.sinkHeaderBold(sink, "|");
                } else {
                    this.sinkCellClass(sink, "", "clover");
                    this.sinkCellClass(sink, "", "clover");
                    this.sinkCellClass(sink, "", "clover");
                    this.sinkCellClass(sink, "", "clover");
                    this.sinkHeaderBold(sink, "|");
                }
            }
            if (this.map.get(SurefireReportBean.class) != null) {
                SurefireReportBean fireReportBean = (SurefireReportBean)mavenProject.getReportsByType(SurefireReportBean.class);
                if (fireReportBean != null) {
                    this.sinkCellPercentGraphic(sink, fireReportBean.getSucessRate() / 100.0, "surefire");
                    this.sinkCellClass(sink, Integer.toString(fireReportBean.getNbTests()), "surefire");
                    this.sinkCellClass(sink, Integer.toString(fireReportBean.getNbErrors()), "surefire");
                    this.sinkCellClass(sink, Integer.toString(fireReportBean.getNbFailures()), "surefire");
                    this.sinkCellClass(sink, Integer.toString(fireReportBean.getNbSkipped()), "surefire");
                    this.sinkCellClass(sink, Double.toString(fireReportBean.getElapsedTime()), "surefire");
                    this.sinkHeaderBold(sink, "|");
                } else {
                    this.sinkCellClass(sink, "", "surefire");
                    this.sinkCellClass(sink, "", "surefire");
                    this.sinkCellClass(sink, "", "surefire");
                    this.sinkCellClass(sink, "", "surefire");
                    this.sinkCellClass(sink, "", "surefire");
                    this.sinkCellClass(sink, "", "surefire");
                    this.sinkHeaderBold(sink, "|");
                }
            }
            if (this.map.get(CheckstyleReportBean.class) != null) {
                CheckstyleReportBean checkStyleReport = (CheckstyleReportBean)mavenProject.getReportsByType(CheckstyleReportBean.class);
                if (checkStyleReport != null) {
                    this.sinkCellClass(sink, Integer.toString(checkStyleReport.getNbClasses()), "checkstyle");
                    this.sinkCellClass(sink, Integer.toString(checkStyleReport.getNbTotal()), "checkstyle");
                    this.sinkCellClass(sink, Integer.toString(checkStyleReport.getNbInfos()), "checkstyle");
                    this.sinkCellClass(sink, Integer.toString(checkStyleReport.getNbWarnings()), "checkstyle");
                    this.sinkCellClass(sink, Integer.toString(checkStyleReport.getNbErrors()), "checkstyle");
                    this.sinkHeaderBold(sink, "|");
                } else {
                    this.sinkCellClass(sink, "", "checkstyle");
                    this.sinkCellClass(sink, "", "checkstyle");
                    this.sinkCellClass(sink, "", "checkstyle");
                    this.sinkCellClass(sink, "", "checkstyle");
                    this.sinkCellClass(sink, "", "checkstyle");
                    this.sinkHeaderBold(sink, "|");
                }
            }
            if (this.map.get(PmdReportBean.class) != null) {
                PmdReportBean pmdReportBean = (PmdReportBean)mavenProject.getReportsByType(PmdReportBean.class);
                if (pmdReportBean != null) {
                    this.sinkCellClass(sink, Integer.toString(pmdReportBean.getNbClasses()), "pmd");
                    this.sinkCellClass(sink, Integer.toString(pmdReportBean.getNbViolations()), "pmd");
                    this.sinkHeaderBold(sink, "|");
                } else {
                    this.sinkCellClass(sink, "", "pmd");
                    this.sinkCellClass(sink, "", "pmd");
                    this.sinkHeaderBold(sink, "|");
                }
            }
            if (this.map.get(CpdReportBean.class) != null) {
                CpdReportBean cpdReportBean = (CpdReportBean)mavenProject.getReportsByType(CpdReportBean.class);
                if (cpdReportBean != null) {
                    this.sinkCellClass(sink, Integer.toString(cpdReportBean.getNbClasses()), "cpd");
                    this.sinkCellClass(sink, Integer.toString(cpdReportBean.getNbDuplicate()), "cpd");
                    this.sinkHeaderBold(sink, "|");
                } else {
                    this.sinkCellClass(sink, "", "cpd");
                    this.sinkCellClass(sink, "", "cpd");
                    this.sinkHeaderBold(sink, "|");
                }
            }
            if (this.map.get(FindBugsReportBean.class) != null) {
                FindBugsReportBean findBugsReportBean = (FindBugsReportBean)mavenProject.getReportsByType(FindBugsReportBean.class);
                if (findBugsReportBean != null) {
                    this.sinkCellClass(sink, Integer.toString(findBugsReportBean.getNbClasses()), "findbugs");
                    this.sinkCellClass(sink, Integer.toString(findBugsReportBean.getNbBugs()), "findbugs");
                    this.sinkCellClass(sink, Integer.toString(findBugsReportBean.getNbErrors()), "findbugs");
                    this.sinkCellClass(sink, Integer.toString(findBugsReportBean.getNbMissingClasses()), "findbugs");
                    this.sinkHeaderBold(sink, "|");
                } else {
                    this.sinkCellClass(sink, "", "findbugs");
                    this.sinkCellClass(sink, "", "findbugs");
                    this.sinkCellClass(sink, "", "findbugs");
                    this.sinkCellClass(sink, "", "findbugs");
                    this.sinkHeaderBold(sink, "|");
                }
            }
            if (this.map.get(TagListReportBean.class) != null) {
                TagListReportBean taglistReportBean = (TagListReportBean)mavenProject.getReportsByType(TagListReportBean.class);
                if (taglistReportBean != null) {
                    this.sinkCellClass(sink, Integer.toString(taglistReportBean.getNbClasses()), "taglist");
                    this.sinkCellClass(sink, Integer.toString(taglistReportBean.getNbTotal()), "taglist");
                    this.sinkHeaderBold(sink, "|");
                } else {
                    this.sinkCellClass(sink, "", "taglist");
                    this.sinkCellClass(sink, "", "taglist");
                    this.sinkHeaderBold(sink, "|");
                }
            }
            sink.tableRow_();
        }
    }

    private void writeProjectCell(Sink sink, DashBoardMavenProject mavenProject, String prefix, String suffix) {
        if (prefix == null || prefix.length() == 0) {
            String artefactId = mavenProject.getArtifactId();
            String link = artefactId.substring(artefactId.lastIndexOf(".") + 1, artefactId.length());
            this.sinkCellWithLink(sink, mavenProject.getProjectName(), link + suffix);
        } else {
            int nbTab = prefix.split("/").length;
            String artefactId = mavenProject.getArtifactId();
            String link = prefix + "/" + artefactId.substring(artefactId.lastIndexOf(".") + 1, artefactId.length());
            this.sinkCellTabWithLink(sink, mavenProject.getProjectName(), nbTab, link + suffix);
        }
    }

    private String writeMultiProjectRow(Sink sink, DashBoardMavenProject mavenProject, String prefix, String suffix) {
        if (prefix == null || prefix.length() == 0) {
            String artefactId = mavenProject.getArtifactId();
            prefix = artefactId.substring(artefactId.lastIndexOf(".") + 1, artefactId.length());
            sink.tableRow();
            this.sinkCellBoldWithLink(sink, mavenProject.getProjectName(), prefix + suffix);
            sink.tableRow_();
        } else {
            sink.tableRow();
            int nbTab = prefix.split("/").length;
            String artefactId = mavenProject.getArtifactId();
            prefix = prefix + "/" + artefactId.substring(artefactId.lastIndexOf(".") + 1, artefactId.length());
            this.sinkCellTabBoldWithLink(sink, mavenProject.getProjectName(), nbTab, prefix + suffix);
            sink.tableRow_();
        }
        return prefix;
    }

    private void writeSuperHeader(Sink sink) {
        sink.tableRow();
        sink.tableHeaderCell();
        sink.nonBreakingSpace();
        sink.tableHeaderCell_();
        if (this.map.get(CoberturaReportBean.class) != null) {
            this.sinkSuperHeaderClass(sink, "Cobertura", 3, "cobertura");
            this.sinkHeaderCollapsedIcon(sink, "cobertura");
        }
        if (this.map.get(CloverReportBean.class) != null) {
            this.sinkSuperHeaderClass(sink, "Clover", 4, "clover");
            this.sinkHeaderCollapsedIcon(sink, "clover");
        }
        if (this.map.get(SurefireReportBean.class) != null) {
            this.sinkSuperHeaderClass(sink, "Surefire", 6, "surefire");
            this.sinkHeaderCollapsedIcon(sink, "surefire");
        }
        if (this.map.get(CheckstyleReportBean.class) != null) {
            this.sinkSuperHeaderClass(sink, "Checkstyle", 5, "checkstyle");
            this.sinkHeaderCollapsedIcon(sink, "checkstyle");
        }
        if (this.map.get(PmdReportBean.class) != null) {
            this.sinkSuperHeaderClass(sink, "PMD", 2, "pmd");
            this.sinkHeaderCollapsedIcon(sink, "pmd");
        }
        if (this.map.get(CpdReportBean.class) != null) {
            this.sinkSuperHeaderClass(sink, "CPD", 2, "cpd");
            this.sinkHeaderCollapsedIcon(sink, "cpd");
        }
        if (this.map.get(FindBugsReportBean.class) != null) {
            this.sinkSuperHeaderClass(sink, "FindBugs", 4, "findbugs");
            this.sinkHeaderCollapsedIcon(sink, "findbugs");
        }
        if (this.map.get(TagListReportBean.class) != null) {
            this.sinkSuperHeaderClass(sink, "Tag List", 2, "taglist");
            this.sinkHeaderCollapsedIcon(sink, "taglist");
        }
        sink.tableRow_();
    }

    private void writeHeader(ResourceBundle bundle, Sink sink, boolean upside) {
        sink.tableRow();
        if (upside) {
            this.sinkHeader(sink, bundle.getString("report.project.name.header"));
        } else {
            this.sinkHeader(sink, "");
        }
        if (this.map.get(CoberturaReportBean.class) != null) {
            this.sinkHeaderClass(sink, bundle.getString("report.cobertura.label.nbclasses"), "cobertura");
            this.sinkHeaderClass(sink, bundle.getString("report.cobertura.label.linecover"), "cobertura");
            this.sinkHeaderClass(sink, bundle.getString("report.cobertura.label.branchcover"), "cobertura");
            this.sinkHeaderBold(sink, "");
        }
        if (this.map.get(CloverReportBean.class) != null) {
            this.sinkHeaderClass(sink, bundle.getString("report.clover.label.total"), "clover");
            this.sinkHeaderClass(sink, bundle.getString("report.clover.label.conditionals"), "clover");
            this.sinkHeaderClass(sink, bundle.getString("report.clover.label.statements"), "clover");
            this.sinkHeaderClass(sink, bundle.getString("report.clover.label.methods"), "clover");
            this.sinkHeaderBold(sink, "");
        }
        if (this.map.get(SurefireReportBean.class) != null) {
            this.sinkHeaderClass(sink, bundle.getString("report.surefire.label.successrate"), "surefire");
            this.sinkHeaderClass(sink, bundle.getString("report.surefire.label.tests"), "surefire");
            this.sinkHeaderClass(sink, bundle.getString("report.surefire.label.errors"), "surefire");
            this.sinkHeaderClass(sink, bundle.getString("report.surefire.label.failures"), "surefire");
            this.sinkHeaderClass(sink, bundle.getString("report.surefire.label.skipped"), "surefire");
            this.sinkHeaderClass(sink, bundle.getString("report.surefire.label.time"), "surefire");
            this.sinkHeaderBold(sink, "");
        }
        if (this.map.get(CheckstyleReportBean.class) != null) {
            this.sinkHeaderClass(sink, bundle.getString("report.checkstyle.files"), "checkstyle");
            this.sinkHeaderClass(sink, bundle.getString("report.checkstyle.column.total"), "checkstyle");
            sink.rawText("<th class=\"checkstyle\">" + bundle.getString("report.checkstyle.column.infos"));
            sink.nonBreakingSpace();
            this.iconInfo(sink);
            sink.rawText("</th>");
            sink.rawText("<th class=\"checkstyle\">" + bundle.getString("report.checkstyle.column.warnings"));
            sink.nonBreakingSpace();
            this.iconWarning(sink);
            sink.rawText("</th>");
            sink.rawText("<th class=\"checkstyle\">" + bundle.getString("report.checkstyle.column.errors"));
            sink.nonBreakingSpace();
            this.iconError(sink);
            sink.rawText("</th>");
            this.sinkHeaderBold(sink, "");
        }
        if (this.map.get(PmdReportBean.class) != null) {
            this.sinkHeaderClass(sink, bundle.getString("report.pmd.label.nbclasses"), "pmd");
            this.sinkHeaderClass(sink, bundle.getString("report.pmd.label.nbviolations"), "pmd");
            this.sinkHeaderBold(sink, "");
        }
        if (this.map.get(CpdReportBean.class) != null) {
            this.sinkHeaderClass(sink, bundle.getString("report.cpd.label.nbclasses"), "cpd");
            this.sinkHeaderClass(sink, bundle.getString("report.cpd.label.nbduplicate"), "cpd");
            this.sinkHeaderBold(sink, "");
        }
        if (this.map.get(FindBugsReportBean.class) != null) {
            this.sinkHeaderClass(sink, bundle.getString("report.findbugs.label.nbclasses"), "findbugs");
            this.sinkHeaderClass(sink, bundle.getString("report.findbugs.label.nbbugs"), "findbugs");
            this.sinkHeaderClass(sink, bundle.getString("report.findbugs.label.nberrors"), "findbugs");
            this.sinkHeaderClass(sink, bundle.getString("report.findbugs.label.nbMissingClasses"), "findbugs");
            this.sinkHeaderBold(sink, "");
        }
        if (this.map.get(TagListReportBean.class) != null) {
            this.sinkHeaderClass(sink, bundle.getString("report.taglist.label.nbclasses"), "taglist");
            this.sinkHeaderClass(sink, bundle.getString("report.taglist.column.nboccurs"), "taglist");
            this.sinkHeaderBold(sink, "");
        }
        sink.tableRow_();
    }

    public void createTotalLine(ResourceBundle bundle, Sink sink, DashBoardMavenProject mavenProject) {
        TagListReportBean taglistReportBean;
        FindBugsReportBean findBugsReportBean;
        CpdReportBean cpdReportBean;
        PmdReportBean pmdReportBean;
        CheckstyleReportBean checkstyleReportBean;
        SurefireReportBean fireReportBean;
        CloverReportBean cloverReportBean;
        sink.tableRow();
        this.sinkHeader(sink, "Total");
        CoberturaReportBean reportBean = (CoberturaReportBean)mavenProject.getReportsByType(CoberturaReportBean.class);
        if (reportBean != null) {
            this.sinkHeaderClass(sink, Integer.toString(reportBean.getNbClasses()), "cobertura");
            this.sinkHeaderCellPercentGraphic(sink, reportBean.getLineCoverRate(), "cobertura");
            this.sinkHeaderCellPercentGraphic(sink, reportBean.getBranchCoverRate(), "cobertura");
            this.sinkHeaderBold(sink, "|");
        }
        if ((cloverReportBean = (CloverReportBean)mavenProject.getReportsByType(CloverReportBean.class)) != null) {
            this.sinkHeaderCellPercentGraphic(sink, cloverReportBean.getPercentCoveredConditionals(), "clover", "(" + cloverReportBean.getCoveredElements() + " / " + cloverReportBean.getElements() + ")");
            this.sinkHeaderCellPercentGraphic(sink, cloverReportBean.getPercentCoveredConditionals(), "clover", "(" + cloverReportBean.getCoveredConditionals() + " / " + cloverReportBean.getConditionals() + ")");
            this.sinkHeaderCellPercentGraphic(sink, cloverReportBean.getPercentCoveredStatements(), "clover", "(" + cloverReportBean.getCoveredStatements() + " / " + cloverReportBean.getStatements() + ")");
            this.sinkHeaderCellPercentGraphic(sink, cloverReportBean.getPercentCoveredMethods(), "clover", "(" + cloverReportBean.getCoveredMethods() + " / " + cloverReportBean.getMethods() + ")");
            this.sinkHeaderBold(sink, "|");
        }
        if ((fireReportBean = (SurefireReportBean)mavenProject.getReportsByType(SurefireReportBean.class)) != null) {
            this.sinkHeaderCellPercentGraphic(sink, fireReportBean.getSucessRate() / 100.0, "surefire");
            this.sinkHeaderClass(sink, Integer.toString(fireReportBean.getNbTests()), "surefire");
            this.sinkHeaderClass(sink, Integer.toString(fireReportBean.getNbErrors()), "surefire");
            this.sinkHeaderClass(sink, Integer.toString(fireReportBean.getNbFailures()), "surefire");
            this.sinkHeaderClass(sink, Integer.toString(fireReportBean.getNbSkipped()), "surefire");
            this.sinkHeaderClass(sink, Double.toString(fireReportBean.getElapsedTime()), "surefire");
            this.sinkHeaderBold(sink, "|");
        }
        if ((checkstyleReportBean = (CheckstyleReportBean)mavenProject.getReportsByType(CheckstyleReportBean.class)) != null) {
            this.sinkHeaderClass(sink, Integer.toString(checkstyleReportBean.getNbClasses()), "checkstyle");
            this.sinkHeaderClass(sink, Integer.toString(checkstyleReportBean.getNbTotal()), "checkstyle");
            this.tableHeaderCellClass(sink, "checkstyle");
            sink.text(Integer.toString(checkstyleReportBean.getNbInfos()));
            this.sinkInvertPercentGraphic(sink, checkstyleReportBean.getPercentInfos());
            this.tableHeaderCell_(sink);
            this.tableHeaderCellClass(sink, "checkstyle");
            sink.text(Integer.toString(checkstyleReportBean.getNbWarnings()));
            this.sinkInvertPercentGraphic(sink, checkstyleReportBean.getPercentWarnings());
            this.tableHeaderCell_(sink);
            this.tableHeaderCellClass(sink, "checkstyle");
            sink.text(Integer.toString(checkstyleReportBean.getNbErrors()));
            this.sinkInvertPercentGraphic(sink, checkstyleReportBean.getPercentErrors());
            this.tableHeaderCell_(sink);
            this.sinkHeaderBold(sink, "|");
        }
        if ((pmdReportBean = (PmdReportBean)mavenProject.getReportsByType(PmdReportBean.class)) != null) {
            this.sinkHeaderClass(sink, Integer.toString(pmdReportBean.getNbClasses()), "pmd");
            this.sinkHeaderClass(sink, Integer.toString(pmdReportBean.getNbViolations()), "pmd");
            this.sinkHeaderBold(sink, "|");
        }
        if ((cpdReportBean = (CpdReportBean)mavenProject.getReportsByType(CpdReportBean.class)) != null) {
            this.sinkHeaderClass(sink, Integer.toString(cpdReportBean.getNbClasses()), "cpd");
            this.sinkHeaderClass(sink, Integer.toString(cpdReportBean.getNbDuplicate()), "cpd");
            this.sinkHeaderBold(sink, "|");
        }
        if ((findBugsReportBean = (FindBugsReportBean)mavenProject.getReportsByType(FindBugsReportBean.class)) != null) {
            this.sinkHeaderClass(sink, Integer.toString(findBugsReportBean.getNbClasses()), "findbugs");
            this.sinkHeaderClass(sink, Integer.toString(findBugsReportBean.getNbBugs()), "findbugs");
            this.sinkHeaderClass(sink, Integer.toString(findBugsReportBean.getNbErrors()), "findbugs");
            this.sinkHeaderClass(sink, Integer.toString(findBugsReportBean.getNbMissingClasses()), "findbugs");
            this.sinkHeaderBold(sink, "|");
        }
        if ((taglistReportBean = (TagListReportBean)mavenProject.getReportsByType(TagListReportBean.class)) != null) {
            this.sinkHeaderClass(sink, Integer.toString(taglistReportBean.getNbClasses()), "taglist");
            this.sinkHeaderClass(sink, Integer.toString(taglistReportBean.getNbTotal()), "taglist");
            this.sinkHeaderBold(sink, "|");
        }
        sink.tableRow_();
    }

    private void sinkHeaderCollapsedIcon(Sink sink, String id) {
        sink.tableHeaderCell();
        String idImg = "Collapsed" + id;
        sink.rawText("<IMG SRC=\"./images/previous.gif\" ALT=\"" + id + "\" name=\"" + idImg + "\" onclick=\"javascript:toggleCol('" + idImg + "','" + id + "');\">");
        sink.tableHeaderCell_();
    }

    private void sinkJavascriptCode(Sink sink) {
        StringBuffer buff = new StringBuffer();
        buff.append("<script type=\"text/javascript\">");
        buff.append("        function toggleCol(imageID,strCol){");
        buff.append("            var ths = document.getElementsByTagName(\"th\");");
        buff.append("            var tds = document.getElementsByTagName(\"td\");");
        buff.append("            var mesimages = document.getElementsByName(imageID);");
        buff.append("            for (idx in ths) {");
        buff.append("                if (ths[idx].className == strCol)");
        buff.append("                {");
        buff.append("                    if (ths[idx].style.display == \"none\") {");
        buff.append("                        ths[idx].style.display = \"\";");
        buff.append("                        for (var i = 0; i < mesimages.length; i++) {");
        buff.append("                            mesimages[i].src = './images/previous.gif';");
        buff.append("                        }");
        buff.append("                    }");
        buff.append("                    else {");
        buff.append("                        ths[idx].style.display = \"none\";");
        buff.append("                        for (var i = 0; i < mesimages.length; i++) {");
        buff.append("                            mesimages[i].src = './images/next.gif';");
        buff.append("                        }");
        buff.append("                    }");
        buff.append("                }");
        buff.append("            }");
        buff.append("            for (idx in tds) {");
        buff.append("                if (tds[idx].className == strCol)");
        buff.append("                {");
        buff.append("                    if (tds[idx].style.display == \"none\") ");
        buff.append("                        tds[idx].style.display = \"\";");
        buff.append("                    else{");
        buff.append("                        tds[idx].style.display = \"none\";");
        buff.append("                    }");
        buff.append("                }");
        buff.append("            }");
        buff.append(" }");
        buff.append("</script>");
        sink.rawText(buff.toString());
    }
}

