/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.jmeter;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.chronos.common.IOUtil;
import org.codehaus.mojo.chronos.jmeter.JMeterSAXFileHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class JMeterLogParser {
    private final SAXParser saxParser;
    private final XMLOutputFactory xmlOutputFactory;
    private final Log log;
    public static final String CHRONOS_RESPONSETIMESAMPLES_DTD = "chronos-responsetimesamples.dtd";

    public JMeterLogParser(Log log) {
        this.log = log;
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        try {
            this.saxParser = saxParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        this.xmlOutputFactory = XMLOutputFactory.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertToChronosXml(File file, File output) throws SAXException, IOException, XMLStreamException {
        JMeterSAXFileHandler saxHandler = new JMeterSAXFileHandler();
        this.log.debug((CharSequence)("Parsing " + file.getName()));
        this.saxParser.parse(file, (DefaultHandler)saxHandler);
        this.log.debug((CharSequence)("Writing Chronos document to " + output.getName()));
        File directory = IOUtil.ensureDir((File)output.getParentFile());
        IOUtil.copyDTDToDir((String)CHRONOS_RESPONSETIMESAMPLES_DTD, (File)directory);
        XMLStreamWriter xmlStreamWriter = null;
        try {
            xmlStreamWriter = this.xmlOutputFactory.createXMLStreamWriter(new BufferedOutputStream(new FileOutputStream(output)), "UTF-8");
            xmlStreamWriter.writeStartDocument("UTF-8", "1.0");
            xmlStreamWriter.writeDTD("<!DOCTYPE responsetimesamples PUBLIC \"SYSTEM\" \"chronos-responsetimesamples.dtd\">");
            saxHandler.writeTo(xmlStreamWriter);
        }
        finally {
            if (xmlStreamWriter != null) {
                xmlStreamWriter.close();
            }
        }
    }
}

