/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.apt;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.apt.AptClassLoader;
import org.codehaus.mojo.apt.LogUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AptUtils {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private AptUtils() {
        throw new AssertionError();
    }

    public static boolean invoke(Log log, List<String> args) throws MojoExecutionException {
        int result;
        Object[] methodArgs;
        Method method;
        Class<?> apt = AptUtils.getAptClass();
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter((Writer)stringWriter, true);
        String[] argsArray = args.toArray(new String[args.size()]);
        try {
            method = apt.getMethod("process", PrintWriter.class, String[].class);
            methodArgs = new Object[]{writer, argsArray};
        }
        catch (NoSuchMethodException exception) {
            try {
                method = apt.getMethod("compile", String[].class, PrintWriter.class);
                methodArgs = new Object[]{argsArray, writer};
            }
            catch (NoSuchMethodException exception2) {
                throw new MojoExecutionException("Error while executing the apt compiler", (Exception)exception2);
            }
        }
        log.debug((CharSequence)"Invoking apt with arguments:");
        LogUtils.log(log, 0, args, (CharSequence)"  ");
        try {
            result = (Integer)method.invoke(null, methodArgs);
        }
        catch (IllegalAccessException exception) {
            throw new MojoExecutionException("Error while executing the apt compiler", (Exception)exception);
        }
        catch (InvocationTargetException exception) {
            throw new MojoExecutionException("Error while executing the apt compiler", (Exception)exception);
        }
        LogUtils.log(log, 2, new StringReader(stringWriter.toString()));
        log.debug((CharSequence)("Apt returned " + result));
        return result == 0;
    }

    public static boolean invokeForked(Log log, File workingDirectory, String executable, String meminitial, String maxmemory, List<String> args) throws MojoExecutionException {
        int result;
        File argsFile;
        Commandline cli = new Commandline();
        cli.setWorkingDirectory(workingDirectory.getAbsolutePath());
        log.debug((CharSequence)("Using working directory " + cli.getWorkingDirectory()));
        cli.setExecutable(executable);
        if (StringUtils.isNotEmpty((String)meminitial)) {
            cli.createArg().setValue("-J-Xms" + meminitial);
        }
        if (StringUtils.isNotEmpty((String)maxmemory)) {
            cli.createArg().setValue("-J-Xmx" + maxmemory);
        }
        try {
            argsFile = AptUtils.createArgsFile(args);
            String argsPath = argsFile.getCanonicalPath().replace(File.separatorChar, '/');
            cli.createArg().setValue("@" + argsPath);
        }
        catch (IOException exception) {
            throw new MojoExecutionException("Error creating arguments file", (Exception)exception);
        }
        log.debug((CharSequence)"Using argument file:");
        LogUtils.log(log, 0, argsFile, (CharSequence)"  ");
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Invoking apt with command " + cli));
        }
        CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        try {
            result = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)err);
        }
        catch (CommandLineException exception) {
            throw new MojoExecutionException("Error while executing the apt compiler", (Exception)((Object)exception));
        }
        LogUtils.log(log, 1, new StringReader(out.getOutput()));
        LogUtils.log(log, 2, new StringReader(err.getOutput()));
        log.debug((CharSequence)("Apt returned " + result));
        return result == 0;
    }

    private static Class<?> getAptClass() throws MojoExecutionException {
        try {
            return Class.forName("com.sun.tools.apt.Main", true, AptClassLoader.INSTANCE);
        }
        catch (ClassNotFoundException exception) {
            throw new MojoExecutionException("Unable to locate the apt compiler in:" + LINE_SEPARATOR + "  " + AptClassLoader.getToolsJar() + LINE_SEPARATOR + "Please ensure you are using JDK 1.5 or above and" + LINE_SEPARATOR + "not a JRE (the com.sun.tools.apt.Main class is required)." + LINE_SEPARATOR + "In most cases you can change the location of your Java" + LINE_SEPARATOR + "installation by setting the JAVA_HOME environment variable.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createArgsFile(List<String> args) throws IOException {
        File file = File.createTempFile(AptUtils.class.getName(), ".argfile");
        file.deleteOnExit();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(file));
            for (String arg : args) {
                if ((arg = arg.replace(File.separatorChar, '/')).contains(" ")) {
                    arg = "\"" + arg + "\"";
                }
                writer.println(arg);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(writer);
            throw throwable;
        }
        IOUtil.close((Writer)writer);
        return file;
    }
}

