/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.xsd;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.xsd.metadata.XsdClassMetadata;
import org.codehaus.modello.plugin.xsd.metadata.XsdModelMetadata;
import org.codehaus.modello.plugins.xml.AbstractXmlGenerator;
import org.codehaus.modello.plugins.xml.metadata.XmlAssociationMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlFieldMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlModelMetadata;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

public class XsdGenerator
extends AbstractXmlGenerator {
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Properties;

    public void generate(Model model, Properties parameters) throws ModelloException {
        this.initialize(model, parameters);
        try {
            this.generateXsd(parameters);
        }
        catch (IOException ex) {
            throw new ModelloException("Exception while generating xsd.", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateXsd(Properties parameters) throws IOException, ModelloException {
        Model objectModel = this.getModel();
        File directory = this.getOutputDirectory();
        if (this.isPackageWithVersion()) {
            directory = new File(directory, this.getGeneratedVersion().toString());
        }
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String xsdFileName = parameters.getProperty("modello.output.xsd.file");
        File f = new File(directory, objectModel.getId() + "-" + this.getGeneratedVersion() + ".xsd");
        if (xsdFileName != null) {
            f = new File(directory, xsdFileName);
        }
        XmlStreamWriter writer = WriterFactory.newXmlWriter((File)f);
        try {
            String namespace;
            PrettyPrintXMLWriter w = new PrettyPrintXMLWriter((Writer)writer);
            writer.write("<?xml version=\"1.0\"?>\n");
            this.initHeader((XMLWriter)w);
            w.startElement("xs:schema");
            w.addAttribute("xmlns:xs", "http://www.w3.org/2001/XMLSchema");
            w.addAttribute("elementFormDefault", "qualified");
            ModelClass root = objectModel.getClass(objectModel.getRoot(this.getGeneratedVersion()), this.getGeneratedVersion());
            XmlModelMetadata xmlModelMetadata = (XmlModelMetadata)root.getModel().getMetadata(XmlModelMetadata.ID);
            XsdModelMetadata xsdModelMetadata = (XsdModelMetadata)root.getModel().getMetadata(XsdModelMetadata.ID);
            if (StringUtils.isNotEmpty((String)xsdModelMetadata.getNamespace())) {
                namespace = xsdModelMetadata.getNamespace(this.getGeneratedVersion());
            } else {
                if (StringUtils.isEmpty((String)xmlModelMetadata.getNamespace())) {
                    throw new ModelloException("Cannot generate xsd without xmlns specification: <model xml.namespace='...'> or <model xsd.namespace='...'>");
                }
                namespace = xmlModelMetadata.getNamespace(this.getGeneratedVersion());
            }
            w.addAttribute("xmlns", namespace);
            String targetNamespace = xsdModelMetadata.getTargetNamespace() == null ? namespace : xsdModelMetadata.getTargetNamespace(this.getGeneratedVersion());
            if (StringUtils.isNotBlank((String)targetNamespace)) {
                w.addAttribute("targetNamespace", targetNamespace);
            }
            w.startElement("xs:element");
            String tagName = this.resolveTagName(root);
            w.addAttribute("name", tagName);
            w.addAttribute("type", root.getName());
            XsdGenerator.writeClassDocumentation((XMLWriter)w, root);
            w.endElement();
            int initialCapacity = objectModel.getClasses(this.getGeneratedVersion()).size();
            this.writeComplexTypeDescriptor((XMLWriter)w, objectModel, root, new HashSet(initialCapacity));
            w.endElement();
        }
        finally {
            writer.close();
        }
    }

    private static void writeClassDocumentation(XMLWriter w, ModelClass modelClass) {
        XsdGenerator.writeDocumentation(w, modelClass.getVersionRange().toString(), modelClass.getDescription());
    }

    private static void writeFieldDocumentation(XMLWriter w, ModelField field) {
        XsdGenerator.writeDocumentation(w, field.getVersionRange().toString(), field.getDescription());
    }

    private static void writeDocumentation(XMLWriter w, String version, String description) {
        if (version != null || description != null) {
            w.startElement("xs:annotation");
            if (version != null) {
                w.startElement("xs:documentation");
                w.addAttribute("source", "version");
                w.writeText(version);
                w.endElement();
            }
            if (description != null) {
                w.startElement("xs:documentation");
                w.addAttribute("source", "description");
                w.writeText(description);
                w.endElement();
            }
            w.endElement();
        }
    }

    private void writeComplexTypeDescriptor(XMLWriter w, Model objectModel, ModelClass modelClass, Set written) {
        boolean mixedContent;
        written.add(modelClass);
        w.startElement("xs:complexType");
        w.addAttribute("name", modelClass.getName());
        List fields = this.getFieldsForClass(modelClass);
        boolean hasContentField = this.hasContentField(fields);
        List attributeFields = this.getAttributeFieldsForClass(modelClass);
        fields.removeAll(attributeFields);
        boolean bl = mixedContent = hasContentField && fields.size() > 0;
        if (mixedContent) {
            w.addAttribute("mixed", "true");
        } else if (hasContentField) {
            w.startElement("xs:simpleContent");
            w.startElement("xs:extension");
            w.addAttribute("base", "xs:string");
        }
        XsdGenerator.writeClassDocumentation(w, modelClass);
        HashSet<ModelClass> toWrite = new HashSet<ModelClass>();
        if (fields.size() > 0) {
            XsdClassMetadata xsdClassMetadata = (XsdClassMetadata)modelClass.getMetadata(XsdClassMetadata.ID);
            boolean compositorAll = "all".equals(xsdClassMetadata.getCompositor());
            if (mixedContent || !hasContentField) {
                if (compositorAll) {
                    w.startElement("xs:all");
                } else {
                    w.startElement("xs:sequence");
                }
            }
            Iterator j = fields.iterator();
            while (j.hasNext()) {
                ModelAssociation association;
                ModelField field = (ModelField)j.next();
                XmlFieldMetadata xmlFieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
                String fieldTagName = this.resolveTagName(field, xmlFieldMetadata);
                if (!hasContentField) {
                    w.startElement("xs:element");
                }
                if (!hasContentField) {
                    w.addAttribute("minOccurs", "0");
                }
                String xsdType = XsdGenerator.getXsdType(field.getType());
                if ("Date".equals(field.getType()) && "long".equals(xmlFieldMetadata.getFormat())) {
                    xsdType = XsdGenerator.getXsdType("long");
                }
                if (xsdType != null || "char".equals(field.getType()) || "Char".equals(field.getType())) {
                    w.addAttribute("name", fieldTagName);
                    if (xsdType != null) {
                        w.addAttribute("type", xsdType);
                    }
                    if (field.getDefaultValue() != null) {
                        w.addAttribute("default", field.getDefaultValue());
                    }
                    XsdGenerator.writeFieldDocumentation(w, field);
                    if (xsdType == null) {
                        XsdGenerator.writeCharElement(w);
                    }
                } else if (this.isInnerAssociation(field)) {
                    association = (ModelAssociation)field;
                    ModelClass fieldModelClass = objectModel.getClass(association.getTo(), this.getGeneratedVersion());
                    toWrite.add(fieldModelClass);
                    if (association.isManyMultiplicity()) {
                        XmlAssociationMetadata xmlAssociationMetadata = (XmlAssociationMetadata)association.getAssociationMetadata(XmlAssociationMetadata.ID);
                        if (xmlAssociationMetadata.isWrappedItems()) {
                            w.addAttribute("name", fieldTagName);
                            XsdGenerator.writeFieldDocumentation(w, field);
                            this.writeListElement(w, xmlFieldMetadata, xmlAssociationMetadata, field, fieldModelClass.getName());
                        } else {
                            if (compositorAll) {
                                throw new IllegalStateException(field.getName() + " field is declared as xml.listStyle=\"flat\" " + "then class " + modelClass.getName() + " MUST be declared as xsd.compositor=\"sequence\"");
                            }
                            if (mixedContent) {
                                w.startElement("xs:element");
                                w.addAttribute("minOccurs", "0");
                            }
                            w.addAttribute("name", this.resolveTagName(fieldTagName, xmlAssociationMetadata));
                            w.addAttribute("type", fieldModelClass.getName());
                            w.addAttribute("maxOccurs", "unbounded");
                            XsdGenerator.writeFieldDocumentation(w, field);
                            if (mixedContent) {
                                w.endElement();
                            }
                        }
                    } else {
                        w.addAttribute("name", fieldTagName);
                        w.addAttribute("type", fieldModelClass.getName());
                        XsdGenerator.writeFieldDocumentation(w, field);
                    }
                } else {
                    if (!"Content".equals(field.getType())) {
                        w.addAttribute("name", fieldTagName);
                    }
                    XsdGenerator.writeFieldDocumentation(w, field);
                    if ((class$java$util$List == null ? XsdGenerator.class$("java.util.List") : class$java$util$List).getName().equals(field.getType())) {
                        association = (ModelAssociation)field;
                        XmlAssociationMetadata xmlAssociationMetadata = (XmlAssociationMetadata)association.getAssociationMetadata(XmlAssociationMetadata.ID);
                        this.writeListElement(w, xmlFieldMetadata, xmlAssociationMetadata, field, XsdGenerator.getXsdType("String"));
                    } else if ((class$java$util$Properties == null ? XsdGenerator.class$("java.util.Properties") : class$java$util$Properties).getName().equals(field.getType()) || "DOM".equals(field.getType())) {
                        XsdGenerator.writePropertiesElement(w);
                    } else if (!"Content".equals(field.getType())) {
                        throw new IllegalStateException("Non-association field of a non-primitive type '" + field.getType() + "' for '" + field.getName() + "' in '" + modelClass.getName() + "' model class");
                    }
                }
                if (hasContentField) continue;
                w.endElement();
            }
            if (!hasContentField || mixedContent) {
                w.endElement();
            }
        }
        Iterator j = attributeFields.iterator();
        while (j.hasNext()) {
            ModelField field = (ModelField)j.next();
            XmlFieldMetadata xmlFieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
            w.startElement("xs:attribute");
            String xsdType = XsdGenerator.getXsdType(field.getType());
            String tagName = this.resolveTagName(field, xmlFieldMetadata);
            w.addAttribute("name", tagName);
            if (xsdType != null) {
                w.addAttribute("type", xsdType);
            }
            if (field.getDefaultValue() != null) {
                w.addAttribute("default", field.getDefaultValue());
            }
            XsdGenerator.writeFieldDocumentation(w, field);
            if ("char".equals(field.getType()) || "Char".equals(field.getType())) {
                XsdGenerator.writeCharElement(w);
            } else if (xsdType == null) {
                throw new IllegalStateException("Attribute field of a non-primitive type '" + field.getType() + "' for '" + field.getName() + "' in '" + modelClass.getName() + "' model class");
            }
            w.endElement();
        }
        if (hasContentField && !mixedContent) {
            w.endElement();
            w.endElement();
        }
        w.endElement();
        Iterator iter = toWrite.iterator();
        while (iter.hasNext()) {
            ModelClass fieldModelClass = (ModelClass)iter.next();
            if (written.contains(fieldModelClass)) continue;
            this.writeComplexTypeDescriptor(w, objectModel, fieldModelClass, written);
        }
    }

    private static void writeCharElement(XMLWriter w) {
        w.startElement("xs:simpleType");
        w.startElement("xs:restriction");
        w.addAttribute("base", "xs:string");
        w.startElement("xs:length");
        w.addAttribute("value", "1");
        w.addAttribute("fixed", "true");
        w.endElement();
        w.endElement();
        w.endElement();
    }

    private static void writePropertiesElement(XMLWriter w) {
        w.startElement("xs:complexType");
        w.startElement("xs:sequence");
        w.startElement("xs:any");
        w.addAttribute("minOccurs", "0");
        w.addAttribute("maxOccurs", "unbounded");
        w.addAttribute("processContents", "skip");
        w.endElement();
        w.endElement();
        w.endElement();
    }

    private void writeListElement(XMLWriter w, XmlFieldMetadata xmlFieldMetadata, XmlAssociationMetadata xmlAssociationMetadata, ModelField field, String type) {
        String fieldTagName = this.resolveTagName(field, xmlFieldMetadata);
        String valuesTagName = this.resolveTagName(fieldTagName, xmlAssociationMetadata);
        w.startElement("xs:complexType");
        w.startElement("xs:sequence");
        w.startElement("xs:element");
        w.addAttribute("name", valuesTagName);
        w.addAttribute("minOccurs", "0");
        w.addAttribute("maxOccurs", "unbounded");
        w.addAttribute("type", type);
        w.endElement();
        w.endElement();
        w.endElement();
    }

    private static String getXsdType(String type) {
        if ("String".equals(type)) {
            return "xs:string";
        }
        if ("boolean".equals(type) || "Boolean".equals(type)) {
            return "xs:boolean";
        }
        if ("byte".equals(type) || "Byte".equals(type)) {
            return "xs:byte";
        }
        if ("short".equals(type) || "Short".equals(type)) {
            return "xs:short";
        }
        if ("int".equals(type) || "Integer".equals(type)) {
            return "xs:int";
        }
        if ("long".equals(type) || "Long".equals(type)) {
            return "xs:long";
        }
        if ("float".equals(type) || "Float".equals(type)) {
            return "xs:float";
        }
        if ("double".equals(type) || "Double".equals(type)) {
            return "xs:double";
        }
        if ("Date".equals(type)) {
            return "xs:dateTime";
        }
        return null;
    }
}

