/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.dom4j;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.java.javasource.JClass;
import org.codehaus.modello.plugin.java.javasource.JMethod;
import org.codehaus.modello.plugin.java.javasource.JParameter;
import org.codehaus.modello.plugin.java.javasource.JSourceCode;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;
import org.codehaus.modello.plugin.java.javasource.JStructure;
import org.codehaus.modello.plugin.java.javasource.JType;
import org.codehaus.modello.plugin.java.metadata.JavaClassMetadata;
import org.codehaus.modello.plugin.java.metadata.JavaFieldMetadata;
import org.codehaus.modello.plugin.model.ModelClassMetadata;
import org.codehaus.modello.plugins.xml.AbstractXmlJavaGenerator;
import org.codehaus.modello.plugins.xml.metadata.XmlAssociationMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlFieldMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlModelMetadata;

public class Dom4jWriterGenerator
extends AbstractXmlJavaGenerator {
    public void generate(Model model, Properties parameters) throws ModelloException {
        this.initialize(model, parameters);
        try {
            this.generateDom4jWriter();
        }
        catch (IOException ex) {
            throw new ModelloException("Exception while generating Dom4j Writer.", (Throwable)ex);
        }
    }

    private void generateDom4jWriter() throws ModelloException, IOException {
        Model objectModel = this.getModel();
        String packageName = objectModel.getDefaultPackageName(this.isPackageWithVersion(), this.getGeneratedVersion()) + ".io.dom4j";
        String marshallerName = this.getFileName("Dom4jWriter");
        JSourceWriter sourceWriter = this.newJSourceWriter(packageName, marshallerName);
        JClass jClass = new JClass(packageName + '.' + marshallerName);
        this.initHeader(jClass);
        this.suppressAllWarnings(objectModel, (JStructure)jClass);
        jClass.addImport("java.io.Writer");
        jClass.addImport("java.util.Arrays");
        jClass.addImport("java.util.Iterator");
        jClass.addImport("java.util.Locale");
        jClass.addImport("java.text.DateFormat");
        jClass.addImport("org.codehaus.plexus.util.xml.Xpp3Dom");
        jClass.addImport("org.dom4j.Document");
        jClass.addImport("org.dom4j.DocumentException");
        jClass.addImport("org.dom4j.DocumentFactory");
        jClass.addImport("org.dom4j.Element");
        jClass.addImport("org.dom4j.io.OutputFormat");
        jClass.addImport("org.dom4j.io.XMLWriter");
        this.addModelImports(jClass, null);
        String root = objectModel.getRoot(this.getGeneratedVersion());
        ModelClass rootClass = objectModel.getClass(root, this.getGeneratedVersion());
        String rootElement = this.resolveTagName(rootClass);
        JMethod marshall = new JMethod("write");
        marshall.addParameter(new JParameter((JType)new JClass("Writer"), "writer"));
        marshall.addParameter(new JParameter((JType)new JClass(root), rootElement));
        marshall.addException(new JClass("java.io.IOException"));
        JSourceCode sc = marshall.getSourceCode();
        sc.add("Document document = new DocumentFactory().createDocument();");
        sc.add("write" + root + "( " + rootElement + ", \"" + rootElement + "\", document );");
        sc.add("OutputFormat format = OutputFormat.createPrettyPrint();");
        sc.add("format.setLineSeparator( System.getProperty( \"line.separator\" ) );");
        sc.add("XMLWriter serializer = new XMLWriter( writer, format );");
        sc.add("serializer.write( document );");
        jClass.addMethod(marshall);
        this.writeAllClasses(objectModel, jClass);
        this.writeHelpers(jClass);
        jClass.print(sourceWriter);
        sourceWriter.close();
    }

    private void writeAllClasses(Model objectModel, JClass jClass) throws ModelloException {
        Iterator i = objectModel.getClasses(this.getGeneratedVersion()).iterator();
        while (i.hasNext()) {
            ModelClass clazz = (ModelClass)i.next();
            JavaClassMetadata javaClassMetadata = (JavaClassMetadata)clazz.getMetadata(JavaClassMetadata.ID);
            if (!javaClassMetadata.isEnabled()) continue;
            this.writeClass(clazz, jClass);
        }
    }

    private void writeClass(ModelClass modelClass, JClass jClass) throws ModelloException {
        XmlFieldMetadata xmlFieldMetadata;
        ModelField field;
        String className = modelClass.getName();
        String uncapClassName = Dom4jWriterGenerator.uncapitalise((String)className);
        JMethod marshall = new JMethod("write" + className);
        marshall.getModifiers().makePrivate();
        marshall.addParameter(new JParameter((JType)new JClass(className), uncapClassName));
        marshall.addParameter(new JParameter((JType)new JClass("String"), "tagName"));
        ModelClassMetadata classMetadata = (ModelClassMetadata)modelClass.getMetadata(ModelClassMetadata.ID);
        if (classMetadata.isRootElement()) {
            marshall.addParameter(new JParameter((JType)new JClass("Document"), "parentElement"));
        } else {
            marshall.addParameter(new JParameter((JType)new JClass("Element"), "parentElement"));
        }
        marshall.addException(new JClass("java.io.IOException"));
        JSourceCode sc = marshall.getSourceCode();
        sc.add("if ( " + uncapClassName + " != null )");
        sc.add("{");
        sc.indent();
        XmlModelMetadata xmlModelMetadata = (XmlModelMetadata)modelClass.getModel().getMetadata(XmlModelMetadata.ID);
        if (classMetadata.isRootElement() && xmlModelMetadata.getNamespace() != null) {
            String namespace = xmlModelMetadata.getNamespace(this.getGeneratedVersion());
            sc.add("Element element = parentElement.addElement( tagName, \"" + namespace + "\" );");
            if (xmlModelMetadata.getSchemaLocation() != null) {
                String url = xmlModelMetadata.getSchemaLocation(this.getGeneratedVersion());
                sc.add("element.addAttribute( \"xmlns:xsi\", \"http://www.w3.org/2001/XMLSchema-instance\" );");
                sc.add("element.addAttribute( \"xsi:schemaLocation\", \"" + namespace + " " + url + "\" );");
            }
        } else {
            sc.add("Element element = parentElement.addElement( tagName );");
        }
        ModelField contentField = null;
        String contentValue = null;
        List modelFields = modelClass.getAllFields(this.getGeneratedVersion(), true);
        modelFields = this.getNonTransientFields(modelFields);
        Iterator i = modelFields.iterator();
        while (i.hasNext()) {
            field = (ModelField)i.next();
            xmlFieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
            JavaFieldMetadata javaFieldMetadata = (JavaFieldMetadata)field.getMetadata(JavaFieldMetadata.ID);
            String fieldTagName = this.resolveTagName(field, xmlFieldMetadata);
            String type = field.getType();
            String value = uncapClassName + "." + this.getPrefix(javaFieldMetadata) + this.capitalise(field.getName()) + "()";
            if (xmlFieldMetadata.isContent()) {
                contentField = field;
                contentValue = value;
                continue;
            }
            if (!xmlFieldMetadata.isAttribute()) continue;
            sc.add(this.getValueChecker(type, value, field));
            sc.add("{");
            sc.addIndented("element.addAttribute( \"" + fieldTagName + "\", " + this.getValue(field.getType(), value, xmlFieldMetadata) + " );");
            sc.add("}");
        }
        if (contentField != null) {
            XmlFieldMetadata xmlFieldMetadata2 = (XmlFieldMetadata)contentField.getMetadata(XmlFieldMetadata.ID);
            sc.add("element.setText( " + this.getValue(contentField.getType(), contentValue, xmlFieldMetadata2) + " );");
        }
        Iterator fieldIterator = modelFields.iterator();
        while (fieldIterator.hasNext()) {
            field = (ModelField)fieldIterator.next();
            xmlFieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
            if (xmlFieldMetadata.isContent() || xmlFieldMetadata.isAttribute()) continue;
            this.processField(field, xmlFieldMetadata, uncapClassName, sc, modelClass, jClass);
        }
        sc.unindent();
        sc.add("}");
        jClass.addMethod(marshall);
    }

    private void processField(ModelField field, XmlFieldMetadata xmlFieldMetadata, String uncapClassName, JSourceCode sc, ModelClass modelClass, JClass jClass) throws ModelloException {
        JavaFieldMetadata javaFieldMetadata = (JavaFieldMetadata)field.getMetadata(JavaFieldMetadata.ID);
        String fieldTagName = this.resolveTagName(field, xmlFieldMetadata);
        String type = field.getType();
        String value = uncapClassName + "." + this.getPrefix(javaFieldMetadata) + this.capitalise(field.getName()) + "()";
        if (field instanceof ModelAssociation) {
            ModelAssociation association = (ModelAssociation)field;
            String associationName = association.getName();
            if (association.isOneMultiplicity()) {
                sc.add(this.getValueChecker(type, value, (ModelField)association));
                sc.add("{");
                sc.addIndented("write" + association.getTo() + "( " + value + ", \"" + fieldTagName + "\", element );");
                sc.add("}");
            } else {
                XmlAssociationMetadata xmlAssociationMetadata = (XmlAssociationMetadata)association.getAssociationMetadata(XmlAssociationMetadata.ID);
                String valuesTagName = this.resolveTagName(fieldTagName, xmlAssociationMetadata);
                type = association.getType();
                String toType = association.getTo();
                boolean wrappedItems = xmlAssociationMetadata.isWrappedItems();
                if ("java.util.List".equals(type) || "java.util.Set".equals(type)) {
                    sc.add(this.getValueChecker(type, value, (ModelField)association));
                    sc.add("{");
                    sc.indent();
                    sc.add("Element listElement = element;");
                    if (wrappedItems) {
                        sc.add("listElement = element.addElement( \"" + fieldTagName + "\" );");
                    }
                    sc.add("for ( Iterator iter = " + value + ".iterator(); iter.hasNext(); )");
                    sc.add("{");
                    sc.indent();
                    if (this.isClassInModel(association.getTo(), modelClass.getModel())) {
                        sc.add(toType + " o = (" + toType + ") iter.next();");
                        sc.add("write" + toType + "( o, \"" + valuesTagName + "\", listElement );");
                    } else {
                        sc.add(toType + " " + Dom4jWriterGenerator.singular((String)Dom4jWriterGenerator.uncapitalise((String)field.getName())) + " = (" + toType + ") iter.next();");
                        sc.add("listElement.addElement( \"" + valuesTagName + "\" ).setText( " + Dom4jWriterGenerator.singular((String)Dom4jWriterGenerator.uncapitalise((String)field.getName())) + " );");
                    }
                    sc.unindent();
                    sc.add("}");
                    sc.unindent();
                    sc.add("}");
                } else {
                    sc.add(this.getValueChecker(type, value, field));
                    sc.add("{");
                    sc.indent();
                    sc.add("Element listElement = element;");
                    if (wrappedItems) {
                        sc.add("listElement = element.addElement( \"" + fieldTagName + "\" );");
                    }
                    sc.add("for ( Iterator iter = " + value + ".keySet().iterator(); iter.hasNext(); )");
                    sc.add("{");
                    sc.indent();
                    sc.add("String key = (String) iter.next();");
                    sc.add("String value = (String) " + value + ".get( key );");
                    if (xmlAssociationMetadata.isMapExplode()) {
                        sc.add("Element assocElement = listElement.addElement( \"" + Dom4jWriterGenerator.singular((String)associationName) + "\" );");
                        sc.add("assocElement.addElement( \"key\" ).setText( key );");
                        sc.add("assocElement.addElement( \"value\" ).setText( value );");
                    } else {
                        sc.add("listElement.addElement( key ).setText( value );");
                    }
                    sc.unindent();
                    sc.add("}");
                    sc.unindent();
                    sc.add("}");
                }
            }
        } else {
            sc.add(this.getValueChecker(type, value, field));
            sc.add("{");
            sc.indent();
            if ("DOM".equals(field.getType())) {
                sc.add("writeXpp3DomToElement( (Xpp3Dom) " + value + ", element );");
            } else {
                sc.add("element.addElement( \"" + fieldTagName + "\" ).setText( " + this.getValue(field.getType(), value, xmlFieldMetadata) + " );");
            }
            sc.unindent();
            sc.add("}");
        }
    }

    private void writeHelpers(JClass jClass) {
        JMethod method = new JMethod("writeXpp3DomToElement");
        method.getModifiers().makePrivate();
        method.addParameter(new JParameter((JType)new JClass("Xpp3Dom"), "xpp3Dom"));
        method.addParameter(new JParameter((JType)new JClass("Element"), "parentElement"));
        JSourceCode sc = method.getSourceCode();
        sc.add("Element element = parentElement.addElement( xpp3Dom.getName() );");
        sc.add("if ( xpp3Dom.getValue() != null )");
        sc.add("{");
        sc.addIndented("element.setText( xpp3Dom.getValue() );");
        sc.add("}");
        sc.add("for ( Iterator i = Arrays.asList( xpp3Dom.getAttributeNames() ).iterator(); i.hasNext(); )");
        sc.add("{");
        sc.indent();
        sc.add("String name = (String) i.next();");
        sc.add("element.addAttribute( name, xpp3Dom.getAttribute( name ) );");
        sc.unindent();
        sc.add("}");
        sc.add("for ( Iterator i = Arrays.asList( xpp3Dom.getChildren() ).iterator(); i.hasNext(); )");
        sc.add("{");
        sc.indent();
        sc.add("Xpp3Dom child = (Xpp3Dom) i.next();");
        sc.add("writeXpp3DomToElement( child, element );");
        sc.unindent();
        sc.add("}");
        jClass.addMethod(method);
    }
}

