/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.impl.majorityjudgment;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.chorem.pollen.votecounting.api.AbstractVoteCounting;
import org.chorem.pollen.votecounting.api.InvalidVoteCountingConfig;
import org.chorem.pollen.votecounting.api.VoteCountings;
import org.chorem.pollen.votecounting.api.model.ChoiceToVoteRenderType;
import org.chorem.pollen.votecounting.api.model.PollenError;
import org.chorem.pollen.votecounting.api.model.VoteCountingConfig;
import org.chorem.pollen.votecounting.api.model.VoteForChoice;
import org.chorem.pollen.votecounting.impl.majorityjudgment.MajorityJudgmentConfig;
import org.chorem.pollen.votecounting.impl.majorityjudgment.MajorityJudgmentVoteCountingStrategy;

public class MajorityJudgmentVoteCounting
extends AbstractVoteCounting {
    public MajorityJudgmentVoteCounting() {
        super(VoteCountings.MajorityJudgment);
    }

    public MajorityJudgmentVoteCountingStrategy newStrategy() {
        return new MajorityJudgmentVoteCountingStrategy();
    }

    @Override
    public MajorityJudgmentConfig createConfig() {
        return new MajorityJudgmentConfig();
    }

    @Override
    public ChoiceToVoteRenderType getVoteValueEditorType() {
        return ChoiceToVoteRenderType.SELECT;
    }

    @Override
    public Optional<Double> getMinimumValue() {
        return Optional.of(0.0);
    }

    @Override
    public List<PollenError> validateVoteForChoice(VoteForChoice voteForChoice, VoteCountingConfig config, Locale locale) {
        List<PollenError> errorMap = super.validateVoteForChoice(voteForChoice, config, locale);
        Double voteValue = voteForChoice.getVoteValue();
        if (voteValue == null) {
            errorMap.add(new PollenError("voteValue", "pollen.voteCountingType.majorityJudgment.voteValue.error.gradeRequired", null, locale, new Object[0]));
        } else if (voteValue != Math.floor(voteValue) || voteValue < 0.0 || voteValue >= (double)InvalidVoteCountingConfig.castVoteCountingConfigOrFail(config, MajorityJudgmentConfig.class).getGrades().size()) {
            errorMap.add(new PollenError("voteValue", "pollen.voteCountingType.majorityJudgment.voteValue.error.gradeUnknown", (Object)voteValue, locale, voteValue));
        }
        return errorMap;
    }
}

