/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.strategy;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.votecounting.model.ChoiceIdAble;
import org.chorem.pollen.votecounting.model.ChoiceScore;
import org.chorem.pollen.votecounting.model.ChoiceToVoteRenderType;
import org.chorem.pollen.votecounting.model.VoteCountingResult;
import org.chorem.pollen.votecounting.model.VoteForChoice;
import org.chorem.pollen.votecounting.model.Voter;
import org.chorem.pollen.votecounting.strategy.AbstractVoteCountingStrategy;
import org.nuiton.i18n.I18n;

public class CondorcetStrategy
extends AbstractVoteCountingStrategy {
    public static final int ID = 2;
    private static final Log log = LogFactory.getLog(CondorcetStrategy.class);

    public int getId() {
        return 2;
    }

    public String getI18nName() {
        return I18n.n_((String)"pollen.voteCountingType.condorcet", (Object[])new Object[0]);
    }

    public String getI18nHelp() {
        return I18n.n_((String)"pollen.voteCountingType.condorcet.help", (Object[])new Object[0]);
    }

    public String getTotalVoteValueNotValidMessage(Locale locale) {
        return null;
    }

    public String getVoteValueNotValidMessage(Locale locale) {
        return I18n.l_((Locale)locale, (String)"pollen.error.vote.invalidCondorcetVoteValue", (Object[])new Object[0]);
    }

    public String getDisplayVoteValue(Integer voteValue) {
        return voteValue == null ? "" : String.valueOf(voteValue);
    }

    public ChoiceToVoteRenderType getVoteValueEditorType() {
        return ChoiceToVoteRenderType.TEXTFIELD;
    }

    public boolean isChoiceInVote(Integer voteValue) {
        return voteValue != null && voteValue > 0 && voteValue < 100;
    }

    public boolean isVoteValueNull(Integer voteValue) {
        return voteValue == null;
    }

    public boolean isDisplayResultsByChoice() {
        return false;
    }

    public boolean isVoteValueValid(Integer voteValue) {
        return voteValue != null && voteValue > 0;
    }

    public boolean isTotalVoteValueValid(int totalValues) {
        return true;
    }

    public VoteCountingResult votecount(Set<Voter> voters) {
        SortedMap resultByChoice = this.votersToResult(voters);
        ArrayList choiceIds = Lists.newArrayList(resultByChoice.keySet());
        int nbChoices = choiceIds.size();
        double[][] matrix = new double[nbChoices][nbChoices];
        Set<String> winners = this.computePairWiseMatrix(choiceIds, voters, matrix);
        this.computeNbBattlesByChoice(resultByChoice, choiceIds, matrix);
        List choiceScores = this.toChoiceScore(resultByChoice);
        if (winners != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Direct winners : " + winners));
            }
            for (String choiceId : winners) {
                ChoiceScore choiceScore = (ChoiceScore)resultByChoice.get(choiceId);
                choiceScores.remove(choiceScore);
                choiceScores.add(0, choiceScore);
            }
        } else {
            this.resolvConflicts(choiceScores, matrix);
        }
        VoteCountingResult result = this.resultToList(resultByChoice);
        return result;
    }

    protected void resolvConflicts(List<ChoiceScore> choiceScores, double[][] matrix) {
    }

    protected void computeNbBattlesByChoice(Map<String, ChoiceScore> resultByChoice, List<String> choiceIds, double[][] matrix) {
        int nbChoices = choiceIds.size();
        for (String choiceId : choiceIds) {
            int i = choiceIds.indexOf(choiceId);
            double nbBattles = 0.0;
            for (int j = 0; j < nbChoices; ++j) {
                double aRow = matrix[i][j];
                nbBattles += aRow;
            }
            resultByChoice.get(choiceId).setScoreValue(BigDecimal.valueOf(nbBattles));
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Nb battle wins for choice " + choiceId + ": " + nbBattles));
        }
    }

    private Set<String> computePairWiseMatrix(List<String> choiceIds, Set<Voter> voters, double[][] matrix) {
        int nbChoices = choiceIds.size();
        HashSet winners = null;
        AbstractVoteCountingStrategy.VoteForChoiceComparator comparator = new AbstractVoteCountingStrategy.VoteForChoiceComparator();
        double[] currentVoteWinner = new double[choiceIds.size()];
        boolean firstVoter = true;
        for (Voter voter : voters) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Start count for voter " + voter.getVoterId()));
            }
            double voterWeight = voter.getWeight();
            Arrays.fill(currentVoteWinner, 0.0);
            ImmutableMap voteByChoiceIds = Maps.uniqueIndex((Iterable)voter.getVoteForChoices(), (Function)new ChoiceIdAble.ChoiceIdAbleById());
            double maxBattleWins = 0.0;
            for (String choiceId : choiceIds) {
                VoteForChoice voteForChoice = (VoteForChoice)voteByChoiceIds.get(choiceId);
                int x = choiceIds.indexOf(choiceId);
                for (VoteForChoice voteForChoice1 : voter.getVoteForChoices()) {
                    String choiceId1 = voteForChoice1.getChoiceId();
                    if (choiceId.equals(choiceId1)) continue;
                    int y = choiceIds.indexOf(choiceId1);
                    int compare = comparator.compare(voteForChoice, voteForChoice1);
                    if (compare >= 0) continue;
                    int pos = x * nbChoices + y;
                    matrix[x][y] = matrix[x][y] + voterWeight;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("battle [" + choiceId + "<" + voteForChoice.getVoteValue() + "> - " + choiceId1 + "<" + voteForChoice1.getVoteValue() + ">] wins (store to " + pos + ", new value=" + matrix[x][y] + ")"));
                    }
                    currentVoteWinner[x] = currentVoteWinner[x] + voterWeight;
                    maxBattleWins = Math.max(maxBattleWins, currentVoteWinner[x]);
                }
            }
            if (firstVoter || winners != null) {
                HashSet currentVoteWinners = Sets.newHashSet();
                for (int i = 0; i < currentVoteWinner.length; ++i) {
                    if (maxBattleWins != currentVoteWinner[i]) continue;
                    String choiceId = choiceIds.get(i);
                    currentVoteWinners.add(choiceId);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Winners of this vote : " + currentVoteWinners));
                }
                if (firstVoter) {
                    winners = currentVoteWinners;
                } else if (!winners.equals(currentVoteWinners)) {
                    winners = null;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Dismatch winners (will need resolv...)");
                    }
                }
            }
            firstVoter = false;
        }
        return winners;
    }
}

