/*
 * #%L
 * Pollen :: VoteCounting Api
 * $Id: VoteCountingStrategyProvider.java 3593 2012-08-12 11:01:15Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4.5/pollen-votecounting-api/src/main/java/org/chorem/pollen/votecounting/strategy/VoteCountingStrategyProvider.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.votecounting.strategy;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;

/**
 * Provider of {@link VoteCountingStrategy}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4.5
 */
public class VoteCountingStrategyProvider {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(VoteCountingStrategyProvider.class);

    /**
     * List of available strageries detected via the {@link ServiceLoader}
     * mecanism no contract {@link VoteCountingStrategy}.
     */
    private final Map<Integer, VoteCountingStrategy> strategies;

    public VoteCountingStrategyProvider() {
        strategies = load();
    }

    public Set<Integer> getStrategyIds() {
        return ImmutableSet.copyOf(strategies.keySet());
    }

    public VoteCountingStrategy getStrategy(int strategyId) throws VoteCountigStrategyNotFound {
        VoteCountingStrategy type = strategies.get(strategyId);

        if (type == null) {
            throw new VoteCountigStrategyNotFound(
                    "Could not find strategy with id " + strategyId);
        }
        try {
            //FIXME-tchemit-2012-06-24 : should we reinstanciate each time ?
            return type.getClass().newInstance();
        } catch (Exception e) {

            throw new VoteCountigStrategyNotFound(
                    "Could not instanciate stragegy " + strategyId, e);
        }
    }

    protected Map<Integer, VoteCountingStrategy> load() {
        Map<Integer, VoteCountingStrategy> result = Maps.newTreeMap();
        ServiceLoader<VoteCountingStrategy> loader =
                ServiceLoader.load(VoteCountingStrategy.class);

        for (VoteCountingStrategy strategy : loader) {
            int id = strategy.getId();
            if (result.containsKey(id)) {
                throw new IllegalStateException(
                        "Strategy [" +
                        strategy.getI18nName() + "] with id " + id +
                        ", can not be used since the id is already used " +
                        "by strategy [" + result.get(id).getI18nName() + "] ");
            }
            if (log.isInfoEnabled()) {
                log.info("Detected strategy [" + id + "-" +
                         strategy.getI18nName() + "] : " +
                         strategy.getClass().getName());
            }
            result.put(id, strategy);
        }
        return result;
    }

}
