/*
 * #%L
 * Pollen :: VoteCounting Api
 * $Id: VoterBuilder.java 3593 2012-08-12 11:01:15Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4.5/pollen-votecounting-api/src/main/java/org/chorem/pollen/votecounting/model/VoterBuilder.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.votecounting.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;

import java.util.Set;

/**
 * To build some {@link Voter}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4.5
 */
public class VoterBuilder {

    private Set<Voter> voters = Sets.newHashSet();

    private Voter voter;

    public VoterBuilder newVoter(String voterId, double weight) {
        flushVoter();
        voter = SimpleVoter.newVoter(voterId, weight, null);
        return this;
    }

    public VoterBuilder addVoteForChoice(String choiceId, Double voteValue) {
        Preconditions.checkState(voter != null);
        VoteForChoice voteForChoice = VoteForChoice.newVote(choiceId, voteValue);
        voter.addVoteForChoice(voteForChoice);
        return this;
    }

    public Set<Voter> getVoters() {
        flushVoter();
        return voters;
    }

    protected void flushVoter() {
        if (voter != null) {
            voters.add(voter);
            voter = null;
        }
    }
}
