/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: SummaryPoll.java 3649 2012-08-28 16:28:18Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4.5/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/poll/admin/SummaryPoll.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll.admin;

import org.chorem.pollen.bean.PollUrl;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.ui.actions.PageSkin;
import org.chorem.pollen.ui.actions.PollenActionSupport;
import org.chorem.pollen.ui.actions.PollenUserSecurityAware;

/**
 * Action to display summary of a poll for his creator (or an admin).
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4
 */
public class SummaryPoll extends PollenActionSupport implements PollenUserSecurityAware {

    private static final long serialVersionUID = 1L;

    public SummaryPoll() {
        super(PageSkin.EDITION);
    }

    public Poll getPoll() {
        return getUserSecurityContext().getPoll();
    }

    public String getVoteUrl() {
        PollUrl url = getPollUrlService().getPollVoteUrl(getPoll());
        if (getPoll().isPollFree()) {

            // can removed accountId only for free poll
            //FIXME Should found out in ohter case the accountId (if exists for the connected id) if no accountId is given
            getUserSecurityContext().removeAccountIdWhenConnected(url);
        } else {
            if (getUserSecurityContext().isRestrictedVoter()) {

                // special case : creator and restricted user (same account still used! find out why)
                // anyway must add the creatorId
                if (!getUserSecurityContext().isConnected()) {

                    // add the accountId
                    url.getPollUri().setAccountId(getUserSecurityContext().getAccountId());
                }
            }
        }
        return url.getUrl();
    }

    public String getShowVoteUrl() {
        PollUrl url = getPollUrlService().getPollVoteUrl(getPoll());
        if (getPoll().isPollFree()) {

            // can removed accountId only for free poll
            //FIXME Should found out in ohter case the accountId (if exists for the connected id) if no accountId is given
            getUserSecurityContext().removeAccountIdWhenConnected(url);
        }
        return url.getUrl();
    }

    public String getModerateUrl() {
        PollUrl url = getPollUrlService().getPollModerateUrl(getPoll());
        getUserSecurityContext().removeAccountIdWhenConnected(url);
        return url.getUrl();
    }

    public String getEditUrl() {
        PollUrl url = getPollUrlService().getPollEditUrl(getPoll());
        getUserSecurityContext().removeAccountIdWhenConnected(url);
        return url.getUrl();
    }

    public String getCloneUrl() {
        PollUrl url = getPollUrlService().getPollCloneUrl(getPoll());
        getUserSecurityContext().removeAccountIdWhenConnected(url);
        return url.getUrl();
    }

    public String getExportUrl() {
        PollUrl url = getPollUrlService().getPollExportUrl(getPoll());
        getUserSecurityContext().removeAccountIdWhenConnected(url);
        return url.getUrl();
    }

    public String getResultUrl() {
        PollUrl url = getPollUrlService().getPollResultUrl(getPoll());
        getUserSecurityContext().removeAccountIdWhenConnected(url);
        return url.getUrl();
    }

    public boolean isCanClose() {
        return getSecurityService().isCanClosePoll(getUserSecurityContext());
    }

    public boolean isCanShowVote() {
        return getPoll().isPublicResults() && !isCanVote();
    }

    public boolean isCanShowResult() {
        boolean result = getSecurityService().isCanAccessResult(getUserSecurityContext());
        return result;
    }

    public boolean isCanVote() {
        return getSecurityService().isCanVote(getUserSecurityContext());
    }

    @Override
    public String execute() throws Exception {

        // nothing to do, everything is contains in the security context.
        return SUCCESS;
    }
}
