/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.security;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.bean.PollUri;
import org.chorem.pollen.services.PollenServiceContext;
import org.chorem.pollen.services.exceptions.PollNotFoundException;
import org.chorem.pollen.services.exceptions.UnauthorizedPollAccessException;
import org.chorem.pollen.services.impl.PollService;
import org.chorem.pollen.ui.security.AbstractPollenAuthorization;
import org.chorem.pollen.ui.security.AdminUserRequired;
import org.chorem.pollen.ui.security.PollCreatorRequired;

public class PollAccessRequired
extends AbstractPollenAuthorization {
    private static final Log log = LogFactory.getLog(PollAccessRequired.class);
    protected final AdminUserRequired adminFilter = new AdminUserRequired();
    protected final PollCreatorRequired pollCreatorFilter = new PollCreatorRequired();

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        boolean isAccessAllowed;
        if (this.adminFilter.isAccessAllowed(request, response, mappedValue)) {
            isAccessAllowed = true;
        } else if (this.pollCreatorFilter.isAccessAllowed(request, response, mappedValue)) {
            isAccessAllowed = true;
        } else {
            PollUri pollUri = this.getPollUri(request);
            if (pollUri == null) {
                isAccessAllowed = false;
            } else {
                PollenServiceContext serviceContext = this.getServiceContext(request);
                PollService pollService = (PollService)serviceContext.newService(PollService.class);
                try {
                    pollService.checkPollAccount(pollUri);
                    isAccessAllowed = true;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Can access to this poll " + pollUri.getPollId()));
                    }
                }
                catch (PollNotFoundException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Poll not found!");
                    }
                    isAccessAllowed = false;
                }
                catch (UnauthorizedPollAccessException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"User can not access page");
                    }
                    isAccessAllowed = false;
                }
            }
        }
        return isAccessAllowed;
    }
}

