/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: DeleteFavoriteList.java 3333 2012-04-30 15:52:41Z fdesbois $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/user/DeleteFavoriteList.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.user;

import com.google.common.base.Preconditions;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.services.exceptions.UserNotFoundException;
import org.chorem.pollen.services.impl.FavoriteService;
import org.chorem.pollen.ui.actions.PollenActionSupport;

/**
 * Delete a selected favorite list for the connected user.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class DeleteFavoriteList extends PollenActionSupport {

    private static final long serialVersionUID = 1L;

    protected String favoriteListId;

    protected String redirectUrl;

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public void setFavoriteListId(String favoriteListId) {
        this.favoriteListId = favoriteListId;
    }

    public String getRedirectUrl() {
        return redirectUrl;
    }

    public String execute() throws Exception {

        Preconditions.checkNotNull(favoriteListId);

        String result = INPUT;

        try {
            FavoriteService service = newService(FavoriteService.class);

            PersonList favoriteList = service.getEntityById(
                    PersonList.class, favoriteListId);

            PersonList deletedFavoritedList = service.deleteFavoriteList(
                    getPollenUserAccount(), favoriteList);

            getTransaction().commitTransaction();

            addFlashMessage(_("pollen.information.favoriteList.deleted",
                              deletedFavoritedList.getName()));

            result = SUCCESS;
        } catch (UserNotFoundException e) {
            addFieldError("deleteUser.login",
                          _("pollen.error.user.not.found"));
        }
        return result;
    }
}
