/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: GetParticipatedPolls.java 3329 2012-04-30 10:45:14Z fdesbois $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/json/GetParticipatedPolls.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.json;

import com.google.common.collect.Sets;
import org.chorem.pollen.bean.PollUri;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.entities.PollenBinderHelper;
import org.chorem.pollen.services.impl.PollService;
import org.nuiton.util.beans.Binder;

import java.util.Map;
import java.util.Set;

/**
 * Obtain participated polls to put in grid for the connected user.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class GetParticipatedPolls extends AbstractJSONPaginedAction {

    private static final long serialVersionUID = 1L;

    protected transient Map<String, Object>[] polls;

    public Map<String, Object>[] getPolls() {
        return polls;
    }

    @Override
    public Integer getRows() {
        return pager.getPageSize();
    }

    @Override
    public Integer getPage() {
        return pager.getPageIndex();
    }

    @Override
    public Integer getTotal() {
        return pager.getPagesNumber();
    }

    @Override
    public Integer getRecords() {
        return pager.getRecords();
    }

    @Override
    public String execute() throws Exception {

        PollService pollService = newService(PollService.class);

        Map<Poll, PollAccount> participatedPolls =
                pollService.getParticipatedPolls(pager, getPollenUserAccount());

        polls = new Map[participatedPolls.size()];
        Binder<Poll, Poll> binder =
                PollenBinderHelper.getSimpleTopiaBinder(Poll.class);
        int index = 0;
        for (Map.Entry<Poll, PollAccount> entry : participatedPolls.entrySet()) {

            Poll poll = entry.getKey();
            Map<String, Object> map = binder.obtainProperties(
                    poll,
                    Poll.PROPERTY_TITLE,
                    Poll.PROPERTY_POLL_ID,
                    Poll.PROPERTY_DESCRIPTION,
                    Poll.PROPERTY_BEGIN_DATE,
                    Poll.PROPERTY_END_DATE
            );
            
            PollAccount account = entry.getValue();

            PollUri pollUri = PollUri.newPollUri(poll.getPollId(), account.getAccountId());
            
            map.put("id", poll.getTopiaId());

            // Keep accountId to allow vote update
            map.put("voteId", pollUri.getUri());

            // For Free poll, it's not necessary to keep the accountId
            String resultId = poll.getPollType() == PollType.FREE
                              ? pollUri.getPollId()
                              : pollUri.getUri();
            map.put("resultId", resultId);
            
            Set<String> functions = getPollFunctions(poll);
            map.put("functions", functions);
            polls[index++] = map;
        }
        return SUCCESS;
    }

    private Set<String> getPollFunctions(Poll poll) {
        Set<String> result = Sets.newHashSet();
        result.add("vote");
        if (poll.isPublicResults()) {

            // only if results are public
            result.add("result");
        }
        return result;
    }
}