/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import org.apache.tapestry5.Asset;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.chenillekit.tapestry.core.services.ThumbNailService;

@SupportsInformalParameters
@Import(library={"../Chenillekit.js", "ThumbNail.js"})
public class ThumbNail
implements ClientElement {
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String clientId;
    @Parameter(name="asset", required=true, defaultPrefix="literal")
    private Object assetObject;
    @Parameter(required=true, defaultPrefix="prop")
    private int thumbHeight;
    @Parameter(value="80", required=false, defaultPrefix="prop")
    private float quality;
    @Parameter(value="false", required=false, defaultPrefix="prop")
    private boolean onClickAction;
    private String assignedClientId;
    @Environmental
    private JavaScriptSupport javascriptSupport;
    @Inject
    private ComponentResources resources;
    @Inject
    private AssetSource assetSource;
    @Inject
    private ThumbNailService thumbNailService;
    private Asset asset;

    void setupRender() {
        this.assignedClientId = this.javascriptSupport.allocateClientId(this.clientId);
        if (this.assetObject instanceof String) {
            this.asset = this.assetSource.getAsset(this.resources.getBaseResource(), (String)this.assetObject, null);
        } else if (this.assetObject instanceof Asset) {
            this.asset = (Asset)this.assetObject;
        } else {
            throw new RuntimeException("parameter 'asset' neither a string nor an asset object");
        }
    }

    void beginRender(MarkupWriter writer) {
        writer.element("img", new Object[]{"id", this.getClientId(), "src", this.generateThumbNail().toClientURL()});
        this.resources.renderInformalParameters(writer);
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
        if (this.onClickAction) {
            this.javascriptSupport.addScript("new Ck.ThumbNail('%s', '%s');", new Object[]{this.getClientId(), this.asset.toClientURL()});
        }
    }

    private Asset generateThumbNail() {
        return this.thumbNailService.convertToThumbnail(this.asset, this.thumbHeight, this.quality);
    }

    public String getClientId() {
        return this.assignedClientId;
    }
}

